package com.liquidnet.service.adam.config;

import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.profile.DefaultProfile;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AliyunDypnsConfigure {
    @Value("${liquidnet.aliyun.accessKeyId}")
    private String accessKeyId;
    @Value("${liquidnet.aliyun.accessSecret}")
    private String accessSecret;

    @Bean
    public DefaultAcsClient initAcsClient() {
        DefaultProfile profile = DefaultProfile.getProfile("cn-hangzhou", accessKeyId, accessSecret);
        return new DefaultAcsClient(profile);
    }
}
