package com.liquidnet.service.goblin.controller.manage;


import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.manage.GoblinGoodsAnticipateAddParam;
import com.liquidnet.service.goblin.dto.manage.GoblinGoodsAnticipateValueParam;
import com.liquidnet.service.goblin.dto.manage.vo.AnticipateValueVo;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinGoodsAnticipateValueVo;
import com.liquidnet.service.goblin.service.manage.IGoblinGoodsAnticipateMgService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigInteger;

/**
 * <p>
 * 预约表 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2022-04-07
 */
@Slf4j
@RestController
@Api(tags = "预约相关(后)")
@RequestMapping("/goblin/anticipate")
public class GoblinGoodsAnticipateMgController {

    @Autowired
    IGoblinGoodsAnticipateMgService goblinGoodsAnticipateMgService;

    @ApiOperation("创建预约信息")
    @PostMapping("/add")
    public ResponseDto<Object> add(@RequestBody GoblinGoodsAnticipateAddParam goodsAnticipateAddParam) {
        return goblinGoodsAnticipateMgService.add(goodsAnticipateAddParam);
    }

    @PostMapping("/list")
    @ApiOperation("获取全部开启预约的sku")
    public ResponseDto<PageInfo<GoblinGoodsAnticipateValueVo>> list(GoblinGoodsAnticipateValueParam goodsAnticipateValueParam) {
        return goblinGoodsAnticipateMgService.list(goodsAnticipateValueParam);
    }

    @ApiOperation("修改预约人数")
    @PostMapping("/updatePeople")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "skuId", value = "skuId", example = ""),
            @ApiImplicitParam(type = "query", dataType = "BigInteger", name = "people", value = "要修改的人数", example = "")
    })
    public ResponseDto<Boolean> updatePeople(@RequestParam(name = "skuId", required = true) String skuId, @RequestParam(name = "people", required = true) BigInteger people) {
        return goblinGoodsAnticipateMgService.updatePeople(skuId, people);
    }

    @ApiOperation("删除预约")
    @DeleteMapping("/delete")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "skuId", value = "skuId", example = ""),
    })
    public ResponseDto<Boolean> delete(@RequestParam(name = "skuId") String skuId) {
        return goblinGoodsAnticipateMgService.delete(skuId);
    }

//    @ApiOperation("更具sku获取信息")
//    @GetMapping("/getAnticipateValueBySkuId")
//    public AnticipateValueVo getAnticipateValueBySkuId(@RequestParam(name = "skuId") String skuId){
//        return goblinGoodsAnticipateMgService.getAnticipateValueBySkuId(skuId,1);
//    }

}
