package com.liquidnet.service.sweet.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import me.chanjar.weixin.common.bean.oauth2.WxOAuth2AccessToken;

import java.io.Serializable;

/**
 * <p>
 * WxOAuth2AccessToken vo
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-09-28
 */

@Data
@ApiModel
public class WechatTokenInfoVo implements Serializable, Cloneable {

    private static final long serialVersionUID = 3404938811111878417L;

    @ApiModelProperty(value = "openId")
    private String openId;

    @ApiModelProperty(value = "unionId")
    private String unionId;

    private static final WechatTokenInfoVo obj = new WechatTokenInfoVo();

    public static WechatTokenInfoVo getNew() {
        try {
            return (WechatTokenInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new WechatTokenInfoVo();
        }
    }

    public WechatTokenInfoVo copy(WxOAuth2AccessToken source) {
        if (null == source) return this;
        this.setOpenId(source.getOpenId());
        this.setUnionId(source.getUnionId());
        return this;
    }

}
