package com.liquidnet.service.base;

import org.apache.logging.log4j.util.PropertiesUtil;
import org.springframework.core.io.support.PropertiesLoaderUtils;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ErrorMapping {
    private static final String errorMapDir = "errormap";
    private static Map<String, Object> errorPropertiesMap = new HashMap<>();

    static {
        try {
            URL url = PropertiesUtil.class.getClassLoader().getResource(errorMapDir);
            if (null != url) {
                File file = new File(url.getFile());
                if (file.exists() && file.isDirectory()) {
                    File[] files = file.listFiles();
                    for (File f : files) {
                        if (f.isFile() && f.getName().endsWith("properties")) {
                            Properties props = PropertiesLoaderUtils.loadAllProperties(errorMapDir.concat("/") + f.getName());
                            for (Object key : props.keySet()) {
                                String keyStr = key.toString();
                                String value = props.getProperty(keyStr);
                                errorPropertiesMap.put(keyStr, value);
                            }
                        }
                    }
                }
            }
            System.out.printf("errorPropertiesMap init count: %s\n", errorPropertiesMap.size());
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ErrorMessage get(String code) {
        return ErrorMessage.instance.setCode(code).setMessage((String) errorPropertiesMap.get(code));
    }

    public static class ErrorMessage implements Cloneable, Serializable {
        private static final long serialVersionUID = 2208924091512163151L;
        private String code;
        private String message;

        public ErrorMessage() {
        }

        public String getCode() {
            return code;
        }

        public String getMessage() {
            return message;
        }

        private final static ErrorMessage instance = new ErrorMessage();

        public static ErrorMessage getInstance() {
            try {
                return (ErrorMessage) instance.clone();
            } catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            return new ErrorMessage();
        }

        public ErrorMessage setCode(String code) {
            this.code = code;
            return this;
        }

        public ErrorMessage setMessage(String message) {
            this.message = message;
            return this;
        }
    }
}
