package com.liquidnet.service.adam.service;

import com.liquidnet.service.adam.dto.AdamThirdPartParam;
import com.liquidnet.service.adam.dto.vo.AdamUserInfoVo;
import com.liquidnet.service.adam.entity.AdamUser;
import com.baomidou.mybatisplus.extension.service.IService;

/**
 * <p>
 * 用户 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-10
 */
public interface IAdamUserService extends IService<AdamUser> {

    String queryUidByRedis(String mobile);

    String queryUidByRedis(String openId, String platform);

    AdamUserInfoVo queryByUid(String uid);

    /**
     * 手机号注册
     *
     * @param mobile
     * @return AdamUserInfoVo
     */
    AdamUserInfoVo register(String mobile);

    /**
     * 第三方账号注册
     *
     * @param thirdPartParam
     * @return AdamUserInfoVo
     */
    AdamUserInfoVo register(AdamThirdPartParam thirdPartParam);
}
