package com.liquidnet.service.adam.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.adam.dto.AdamAddressesParam;
import com.liquidnet.service.adam.dto.vo.AdamAddressesVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 收货地址 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-10
 */
@ApiSupport(order = 10060)
@Api(tags = "收获地址")
@Slf4j
@RestController
@RequestMapping("addr")
public class AdamAddressesController {

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "添加收获地址")
    @PostMapping("add")
    public ResponseDto<Object> add(@RequestBody AdamAddressesParam parameter) {
        // TODO: 2021/4/28 数据校验、身份认证、获取登录UID
        String uid = "1";

        // TODO: 2021/5/10


        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "收获地址列表")
    @GetMapping("list")
    public ResponseDto<List<AdamAddressesVo>> list() {
        // TODO: 2021/4/29 获取登录UID
        String uid = "1";


        List<AdamAddressesVo> voList = new ArrayList<>();
        voList.add(AdamAddressesVo.getNew());
        voList.add(AdamAddressesVo.getNew());
        // TODO: 2021/5/10


        return ResponseDto.success(voList);
    }

    @ApiOperationSupport(order = 3)
    @ApiOperation(value = "设置默认收货地址")
    @PostMapping("def/{addrId}")
    public ResponseDto<Object> def(@PathVariable String addrId) {
        // TODO: 2021/4/28 数据校验、身份认证、获取登录UID
        String uid = "1";

        // TODO: 2021/5/10


        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 4)
    @ApiOperation(value = "编辑收获地址")
    @PostMapping("edit")
    public ResponseDto<Object> edit(@RequestBody AdamAddressesParam parameter) {
        // TODO: 2021/4/28 校验、获取登录UID
        String uid = "1";

        // TODO: 2021/5/11


        return ResponseDto.success();
    }

    @ApiOperationSupport(order = 5)
    @ApiOperation(value = "删除收获地址")
    @PostMapping("del/{addrId}")
    public ResponseDto<Object> del(@PathVariable String addrId) {
        // TODO: 2021/4/28 校验、获取登录UID
        String uid = "1";

        // TODO: 2021/5/11


        return ResponseDto.success();
    }
}
