package com.liquidnet.service.adam.service.impl;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.adam.constant.AdamRedisConst;
import com.liquidnet.service.adam.dto.vo.AdamThirdPartInfoVo;
import com.liquidnet.service.adam.entity.AdamThirdParty;
import com.liquidnet.service.adam.mapper.AdamThirdPartyMapper;
import com.liquidnet.service.adam.service.IAdamThirdPartyService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 用户第三方账号信息 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-10
 */
@Service
public class AdamThirdPartyServiceImpl extends ServiceImpl<AdamThirdPartyMapper, AdamThirdParty> implements IAdamThirdPartyService {
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    RedisUtil redisUtil;

    @Override
    public List<AdamThirdPartInfoVo> queryByUid(String uid) {
        List<AdamThirdPartInfoVo> thirdPartInfoVo = (List<AdamThirdPartInfoVo>) redisUtil.hget(AdamRedisConst.INFO_THIRD_PARTY, uid);
        if (null == thirdPartInfoVo) {
            thirdPartInfoVo = mongoTemplate.find(Query.query(Criteria.where("uid").is(uid).and("state").is(1)),
                    AdamThirdPartInfoVo.class, AdamThirdPartInfoVo.class.getSimpleName());

            redisUtil.hset(AdamRedisConst.INFO_THIRD_PARTY, uid, thirdPartInfoVo);
        }
        return thirdPartInfoVo;
    }

    @Override
    public AdamThirdPartInfoVo queryByOpenId(String openId, String platform) {
        AdamThirdPartInfoVo thirdPartInfoVo = (AdamThirdPartInfoVo) redisUtil.hget(AdamRedisConst.INFO_THIRD_PARTY.concat(platform), openId);
        if (null == thirdPartInfoVo) {
            thirdPartInfoVo = mongoTemplate.findOne(Query.query(Criteria.where("openId").is(openId)
                            .and("platform").is(platform).and("state").is(1)),
                    AdamThirdPartInfoVo.class, AdamThirdPartInfoVo.class.getSimpleName());
        }
        return thirdPartInfoVo;
    }
}
