package com.liquidnet.service.adam.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.adam.constant.AdamRedisConst;
import com.liquidnet.service.adam.dto.AdamThirdPartParam;
import com.liquidnet.service.adam.dto.vo.AdamThirdPartInfoVo;
import com.liquidnet.service.adam.dto.vo.AdamUserInfoVo;
import com.liquidnet.service.adam.entity.AdamUser;
import com.liquidnet.service.adam.mapper.AdamUserMapper;
import com.liquidnet.service.adam.service.IAdamUserService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;

/**
 * <p>
 * 用户 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-10
 */
@Service
public class AdamUserServiceImpl extends ServiceImpl<AdamUserMapper, AdamUser> implements IAdamUserService {
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    RabbitTemplate rabbitTemplate;
    @Autowired
    RedisUtil redisUtil;

    @Override
    public AdamUserInfoVo queryByUid(String uid) {
        AdamUserInfoVo userInfoVo = (AdamUserInfoVo) redisUtil.hget(AdamRedisConst.INFO_USER, uid);
        if (null == userInfoVo) {
            userInfoVo = mongoTemplate.findOne(Query.query(Criteria.where("uid").is(uid).and("state").is(1)),
                    AdamUserInfoVo.class, AdamUserInfoVo.class.getSimpleName());

            redisUtil.hset(AdamRedisConst.INFO_USER, uid, userInfoVo);
        }
        return userInfoVo;
    }

    @Override
    public String queryUidByRedis(String mobile) {
        return (String) redisUtil.hget(AdamRedisConst.INFO_IDENTITY_MOBILE, mobile);

//        AdamUserInfoVo userInfoVo;
//        if (null == (userInfoVo = (AdamUserInfoVo) redisUtil.hget(AdamRedisConst.INFO_MOBILES, mobile))) {
//            userInfoVo = mongoTemplate.findOne(Query.query(Criteria.where("mobile").is(mobile).and("state").is(1)),
//                    AdamUserInfoVo.class, AdamUserInfoVo.class.getSimpleName());
//
//            redisUtil.hset(AdamRedisConst.INFO_MOBILES, mobile, userInfoVo);
//        }
//        return userInfoVo;
    }

    @Override
    public String queryUidByRedis(String openId, String platform) {
        return (String) redisUtil.hget(AdamRedisConst.INFO_IDENTITY_THIRD_PARTY, platform.concat(openId));
    }

    @Override
    public AdamUserInfoVo register(String mobile) {
        AdamUserInfoVo userInfoVo = AdamUserInfoVo.getNew();
        userInfoVo.setMobile(mobile);
        userInfoVo.setUid(IDGenerator.nextSnowId() + "");
        userInfoVo.setIsComplete(0);
        userInfoVo.setState(1);
        userInfoVo.setCreateAt(DateUtil.format(LocalDateTime.now(), DateUtil.Formatter.yyyyMMddHHmmss));

//        boolean hset = redisUtil.hset(AdamRedisConst.INFO_MOBILES, userInfoVo.getMobile(), userInfoVo);

        Collection<AdamUserInfoVo> vos = mongoTemplate.insert(Collections.singletonList(userInfoVo), AdamUserInfoVo.class.getSimpleName());

        redisUtil.hset(AdamRedisConst.INFO_IDENTITY_MOBILE, mobile, userInfoVo.getUid());

        return userInfoVo;
    }

    @Override
    public AdamUserInfoVo register(AdamThirdPartParam thirdPartParam) {
        String uid = this.queryUidByRedis(thirdPartParam.getMobile());
        LocalDateTime now = LocalDateTime.now();
        AdamUserInfoVo userInfoVo;
        if (StringUtils.isEmpty(uid)) {
            userInfoVo = AdamUserInfoVo.getNew();

            userInfoVo.setMobile(thirdPartParam.getMobile());
            userInfoVo.setUid(IDGenerator.nextSnowId() + "");
            userInfoVo.setCreateAt(DateUtil.format(now, DateUtil.Formatter.yyyyMMddHHmmss));
        } else {
            userInfoVo = this.queryByUid(uid);
        }

        AdamThirdPartInfoVo thirdPartInfoVo = AdamThirdPartInfoVo.getNew();
        BeanUtils.copyProperties(thirdPartParam, thirdPartInfoVo);
        thirdPartInfoVo.setUid(userInfoVo.getUid());
        thirdPartInfoVo.setState(1);// 1-绑定

//        boolean userInfoSetRst = redisUtil.hset(AdamRedisConst.INFO_MOBILES, thirdPartParam.getMobile(), userInfoVo);
//        boolean thirdPartSetRst = redisUtil.hset(AdamRedisConst.INFO_THIRD_PARTY.concat(thirdPartInfoVo.getPlatform()), thirdPartInfoVo.getOpenId(), thirdPartInfoVo);

        Collection<AdamUserInfoVo> userInfoVos = mongoTemplate.insert(Collections.singletonList(userInfoVo), AdamUserInfoVo.class);
        Collection<AdamThirdPartInfoVo> thirdPartInfoVos = mongoTemplate.insert(Collections.singletonList(thirdPartInfoVo), AdamThirdPartInfoVo.class);

        redisUtil.hset(AdamRedisConst.INFO_IDENTITY_THIRD_PARTY, thirdPartParam.getPlatform().concat(thirdPartParam.getOpenId()), userInfoVo.getUid());

//        List<Object> paramList = Arrays.asList();
//        rabbitTemplate.convertAndSend(MQConst.EXCHANGES_LIQUIDNET_SQL, MQConst.ROUTING_KEY_SQL,
//                SqlMapping.get("adam_user.add", paramList.toArray()));
        return userInfoVo;
    }


}
