package com.liquidnet.service.candy.dto.admin;

import com.liquidnet.service.candy.entity.CandyCoupon;
import lombok.Data;

import java.io.Serializable;

@Data
public class CandyCouponFilterDto implements Serializable, Cloneable {
    private static final long serialVersionUID = -3287018184399499549L;
    private String couponId;
    private String title;

    private static final CandyCouponFilterDto obj = new CandyCouponFilterDto();

    public static CandyCouponFilterDto getNew() {
        try {
            return (CandyCouponFilterDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new CandyCouponFilterDto();
        }
    }

    public CandyCouponFilterDto copy(CandyCoupon source) {
        if (null == source) return this;
        this.setCouponId(source.getCouponId());
        this.setTitle(source.getTitle());
        return this;
    }
}
