package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDateTime;
import java.io.Serializable;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 订单关系
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinOrderTicketRelations implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * order_ticket_relations_id
     */
    private String orderTicketRelationsId;

    /**
     * 订单id
     */
    private String orderId;

    /**
     * 转增订单id
     */
    private String transferId;

    /**
     * 关联直播id
     */
    private String liveId;

    /**
     * 分销代理id
     */
    private String agentId;

    /**
     * 购买者是否是会员
     */
    private Integer isMember;

    /**
     * 演出id
     */
    private String performanceId;

    /**
     * 场次id
     */
    private String timeId;

    /**
     * 票id
     */
    private String ticketId;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 修改时间
     */
    private LocalDateTime updatedAt;

    /**
     * 获取 添加 数据库参数
     *
     * @return
     */
    public Object[] getAddObject() {
        return new Object[]{
                orderTicketRelationsId, orderId, transferId, liveId, agentId, isMember, performanceId, timeId, ticketId, createdAt, updatedAt
        };
    }

}
