package com.liquidnet.service.goblin.controller;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.service.IGoblinGoodsAnticipateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * <p>
 * 预约表 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2022-04-07
 */
@Slf4j
@RestController
@Api(tags = "预约相关")
@RequestMapping("/goblin/anticipate")
public class GoblinGoodsAnticipateController {

    @Autowired
    IGoblinGoodsAnticipateService goblinGoodsAnticipateService;

    @ApiOperation("用户预约 （只能预约不能取消）")
    @PostMapping("/userAbout")
    public ResponseDto<Object> userAbout(@RequestParam(name = "skuId", required = true) String skuId,
                                         @RequestParam(name = "uid", required = true) String uid,
                                         @RequestParam(name = "phone", required = true) String phone) {
        return goblinGoodsAnticipateService.userAbout(skuId, uid, phone);
    }

    @ApiOperation("根据skuId和uid查询")
    @GetMapping("/selectAnticipateBySkuIdAndUid")
    public ResponseDto<Boolean> selectAnticipate(@RequestParam(name = "skuId") String skuId,@RequestParam(name = "uid") String uid){
        return goblinGoodsAnticipateService.selectAnticipate(skuId,uid);
    }

}
