package com.liquidnet.service.goblin.service.impl;

import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.goblin.dto.manage.GoblinGoodsAnticipateAddParam;
import com.liquidnet.service.goblin.dto.manage.GoblinGoodsAnticipateValueAddParam;
import com.liquidnet.service.goblin.dto.manage.GoblinGoodsAnticipateValueParam;
import com.liquidnet.service.goblin.dto.manage.vo.AnticipateValueVo;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinGoodsAnticipateValueVo;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodAnticipateUserVo;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsAnticipateVo;
import com.liquidnet.service.goblin.service.IGoblinGoodsAnticipateService;
import com.liquidnet.service.goblin.service.manage.IGoblinGoodsAnticipateMgService;
import com.liquidnet.service.goblin.util.GoblinMongoUtils;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import com.liquidnet.service.goblin.util.QueueUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigInteger;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

/**
 * <p>
 * 预约表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2022-04-07
 */
@Service
@Slf4j
public class GoblinGoodsAnticipateServiceImpl implements IGoblinGoodsAnticipateService {


    @Autowired
    GoblinRedisUtils goblinRedisUtils;

    @Autowired
    QueueUtils queueUtils;

    @Override
    public ResponseDto<Object> userAbout(String skuId, String uid, String phone) {
        //查询该skuId是否能被预约
        GoblinGoodsAnticipateValueVo anticipateValueVo = goblinRedisUtils.getValueBySkuId(skuId);
        if (anticipateValueVo != null) {
            anticipateValueVo.setState(setState(anticipateValueVo.getAboutStartDate(), anticipateValueVo.getAboutEndDate()));
            if (!anticipateValueVo.getState().equals(1)) {
                return ResponseDto.failure("该商品预约尚未开始或已经结束，不可预约！");
            }
            //查询该用户是否预
            GoblinGoodAnticipateUserVo userVo = goblinRedisUtils.getUserAboutAut(skuId, uid);
            LinkedList<Object[]> sqlValue = CollectionUtil.linkedListObjectArr();
            if (userVo == null) {
                GoblinGoodAnticipateUserVo user = new GoblinGoodAnticipateUserVo();
                user.setUid(uid);
                user.setSkuId(skuId);
                user.setPhone(phone);
                user.setState(0);
                //mongodb记录
                goblinRedisUtils.setUserAboutSku(user);
                //用户没有预约过
                //发送redis消息修改mysql记录用户预约
                sqlValue.add(new Object[]{
                        uid,
                        skuId,
                        phone,
                        0
                });
                sendRedis("goblin_goods_anticipate_user", sqlValue);
                goblinRedisUtils.setSkuIdPeople(skuId);
                //储存用户头像
                userAvatar(skuId);
            }
            return ResponseDto.success();
        }
        return ResponseDto.failure("该预约不存在！");
    }

    @Override
    public ResponseDto<Boolean> selectAnticipate(String skuId, String uid) {
        return ResponseDto.success(goblinRedisUtils.getUserAboutAut(skuId, uid) != null) ;
    }

    private Integer setState(LocalDateTime startDate, LocalDateTime endDate) {

        LocalDateTime now = LocalDateTime.now();
        if (startDate.isAfter(now)) {
            //未开始  0
            return 0;
        }
        if (startDate.isBefore(now) && endDate.isAfter(now)) {
            //预约中 1
            return 1;
        }
        if (endDate.isBefore(now)) {
            //已结束 2
            return 2;
        }
        //其他
        return null;
    }

    private void userAvatar(String skuId) {
        //获取
        goblinRedisUtils.setUserAvatar(skuId);
    }

    public void sendRedis(String sqlKey, LinkedList<Object[]> sqlData) {
        LinkedList<String> sql = CollectionUtil.linkedListString();
        sql.add(SqlMapping.get(sqlKey));
        String sqlStr = SqlMapping.gets(sql, sqlData);
        queueUtils.sendMsgByRedis(
                MQConst.GoblinQueue.GOBLIN_STORE_MARKET.getKey(),
                sqlStr);
    }

}
