package com.liquidnet.service.candy.controller;


import com.fasterxml.jackson.core.type.TypeReference;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.candy.param.BackCouponParam;
import com.liquidnet.service.candy.service.ICandyCouponService;
import com.liquidnet.service.candy.util.ObjectUtil;
import com.liquidnet.service.candy.vo.CandyCouponPreVo;
import com.liquidnet.service.candy.vo.CandyCouponVo;
import com.liquidnet.service.candy.vo.CandyMyCouponListVo;
import com.liquidnet.service.candy.vo.CandyUseResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * <p>
 * 券基础信息 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-18
 */
@Api(tags = "券相关接口")
@RestController
@Validated
@RequestMapping("/candy-coupon")
public class CandyCouponController {

    @Autowired
    private ICandyCouponService candyCouponService;

    //我的券列表
    @GetMapping("my")
    @ApiOperation("我的券列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "Integer", name = "type", value = "类型 1可用 2过期/已使用 ", required = true),
    })
    public ResponseDto<CandyMyCouponListVo> myCoupon(@RequestParam("type") @NotNull Integer type, @RequestParam(required = false, name = "page") Integer page) {
        CandyMyCouponListVo vo = candyCouponService.myCoupon(type);
//        List<CandyCouponVo> list = vo.getMyCoupon();
//        List<CandyCouponVo> listVo = ObjectUtil.getCandyCouponVoArrayList();
//        if (page == null || page == 0) {
//            page = 1;
//        }
//        int size = 40;
//        int initSize = (page - 1) * size;
//        int forSize = page * size;
//        if (forSize >= list.size()) {
//            forSize = list.size();
//        }
//        for (int i = initSize; i < forSize; i++) {
//            listVo.add(list.get(i));
//        }
//        vo.setMyCoupon(listVo);
        return ResponseDto.success(vo);
    }

    //我的会员权益券统计
    @GetMapping("member-pre")
    @ApiOperation("会员权益券统计")
    public ResponseDto<List<CandyCouponPreVo>> myCouponPre() {
        return ResponseDto.success(candyCouponService.memberCouponPre(CurrentUtil.getCurrentUid()));
    }

    //我的会员权益券列表
    @GetMapping("member")
    @ApiOperation("会员权益券列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "String", name = "mCouponId", value = "mCouponId", required = true),
    })
    public ResponseDto<List<CandyCouponVo>> myCoupon(@RequestParam("mCouponId") @NotNull @NotBlank String mCouponId) {
        return ResponseDto.success(candyCouponService.memberCoupon(mCouponId));
    }

    //要使用券列表 - 演出
    @GetMapping("preUse/performance")
    @ApiOperation("要使用券列表 - 演出")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "BigDecimal", name = "priceTotal", value = "待支付总金额", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "performanceId", value = "演出id", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "timeId", value = "场次id", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "ticketId", value = "票id", required = true),
            @ApiImplicitParam(type = "form", dataType = "Integer", name = "type", value = "类型 1可用 2过期/已使用 ", required = true),
    })
    public ResponseDto<CandyMyCouponListVo> preUsePerformanceCoupon(@RequestParam("priceTotal") @NotNull BigDecimal priceTotal,
                                                                    @RequestParam("performanceId") @NotNull @NotBlank String performanceId,
                                                                    @RequestParam("timeId") @NotNull @NotBlank String timeId,
                                                                    @RequestParam("ticketId") @NotNull @NotBlank String ticketId,
                                                                    @RequestParam("type") @NotNull Integer type,
                                                                    @RequestParam(required = false, name = "page") Integer page) {
        CandyMyCouponListVo vo = candyCouponService.preUsePerformanceCoupon(priceTotal, performanceId, timeId, ticketId, type);
        List<CandyCouponVo> list = vo.getMyCoupon();
        List<CandyCouponVo> listVo = ObjectUtil.getCandyCouponVoArrayList();
        if (page == null || page == 0) {
            page = 1;
        }
        int size = 10;
        int initSize = (page - 1) * size;
        int forSize = page * size;
        if (forSize >= list.size()) {
            forSize = list.size();
        }
        for (int i = initSize; i < forSize; i++) {
            listVo.add(list.get(i));
        }
        vo.setMyCoupon(listVo);
        return ResponseDto.success(vo);
    }

    // 是否可用券演出
    @GetMapping("preCanUse/performance")
    @ApiOperation("是否可用券 - 演出")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "BigDecimal", name = "priceTotal", value = "待支付总金额", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "performanceId", value = "演出id", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "timeId", value = "场次id", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "ticketId", value = "票id", required = true),
    })
    public ResponseDto<HashMap<String, Integer>> preCanUsePerformanceCoupon(@RequestParam("priceTotal") @NotNull BigDecimal priceTotal,
                                                                            @RequestParam("performanceId") @NotNull @NotBlank String performanceId,
                                                                            @RequestParam("timeId") @NotNull @NotBlank String timeId,
                                                                            @RequestParam("ticketId") @NotNull @NotBlank String ticketId) {
        HashMap<String, Integer> hashMap = CollectionUtil.mapStringInteger();
        hashMap.put("canUse", candyCouponService.preCanUsePerformanceCoupon(priceTotal, performanceId, timeId, ticketId));
        return ResponseDto.success(hashMap);
    }


    //要使用券列表 - 商品
    @PostMapping("preUse/goods")
    @ApiOperation("要使用券列表 - 商品")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "BigDecimal", name = "priceTotal", value = "待支付总金额", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "goodId", value = "商品id(逗号隔开的字符串)", required = true),
            @ApiImplicitParam(type = "form", dataType = "Integer", name = "type", value = "类型 1可用 2过期/已使用 ", required = true),
    })
    public ResponseDto<CandyMyCouponListVo> preUseGoodCoupon(@RequestParam("priceTotal") @NotNull BigDecimal priceTotal,
                                                             @RequestParam("goodId") @NotNull @NotBlank String goodId,
                                                             @RequestParam("type") @NotNull Integer type,
                                                             @RequestParam(required = false, name = "page") Integer page) {
        CandyMyCouponListVo vo = candyCouponService.preUseGoodCoupon(priceTotal, goodId, type);
        List<CandyCouponVo> list = vo.getMyCoupon();
        List<CandyCouponVo> listVo = ObjectUtil.getCandyCouponVoArrayList();
        if (page == null || page == 0) {
            page = 1;
        }
        int size = 10;
        int initSize = (page - 1) * size;
        int forSize = page * size;
        if (forSize >= list.size()) {
            forSize = list.size();
        }
        for (int i = initSize; i < forSize; i++) {
            listVo.add(list.get(i));
        }
        vo.setMyCoupon(listVo);
        return ResponseDto.success(vo);
    }

    //是否可用券 - 商品
    @PostMapping("preCanUse/goods")
    @ApiOperation("是否可用券 - 商品")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "BigDecimal", name = "priceTotal", value = "待支付总金额", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "goodId", value = "商品id(逗号隔开的字符串)", required = true)
    })
    public ResponseDto<HashMap<String, Integer>> preCanUseGoodCoupon(@RequestParam("priceTotal") @NotNull BigDecimal priceTotal,
                                                                     @RequestParam("goodId") @NotNull @NotBlank String goodId) {
        HashMap<String, Integer> hashMap = CollectionUtil.mapStringInteger();
        hashMap.put("canUse", candyCouponService.preCanUseGoodCoupon(priceTotal, goodId));
        return ResponseDto.success(hashMap);
    }


    //要使用券列表 - 演出提前
    @GetMapping("my/advance")
    @ApiOperation("提前券列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "String", name = "performanceId", value = "演出id", required = true)
    })
    public ResponseDto<List<CandyCouponVo>> myAdvanceCoupon(@RequestParam("performanceId") @NotNull @NotBlank String performanceId,
                                                            @RequestParam(required = false, name = "page") Integer page) {
        List<CandyCouponVo> list = candyCouponService.myAdvanceCoupon(performanceId);
        List<CandyCouponVo> listVo = ObjectUtil.getCandyCouponVoArrayList();
        if (page == null || page == 0) {
            page = 1;
        }
        int size = 10;
        int initSize = (page - 1) * size;
        int forSize = page * size;
        if (forSize >= list.size()) {
            forSize = list.size();
        }

        for (int i = initSize; i < forSize; i++) {
            listVo.add(list.get(i));
        }
        return ResponseDto.success(listVo);
    }

//    //判断券是否可用
//    @GetMapping("state")
//    @ApiOperation("券是否可用")
//    @ApiImplicitParams({
//            @ApiImplicitParam(type = "form", dataType = "String", name = "uCouponId", value = "券唯一表示id", required = true),
//    })
//    public ResponseDto<HashMap<String, Integer>> stateCoupon(@RequestParam("uCouponId") @NotNull @NotBlank String uCouponId) {
//        Integer result = candyCouponService.stateCoupon(uCouponId);
//        if (result == null) {
//            return ResponseDto.failure();
//        }
//        HashMap<String, Integer> hashMap = CollectionUtil.mapStringInteger();
//        hashMap.put("state", result);
//        return ResponseDto.success(hashMap);
//    }

    //判断券是否可用并使用
    @PostMapping("use")
    @ApiOperation("券使用")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "String", name = "uCouponId", value = "券唯一表示id", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "content", value = "消费内容", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "totalPrice", value = "消费价格", required = true),

            @ApiImplicitParam(type = "form", dataType = "String", name = "goodId", value = "商品id(逗号隔开的字符串) 没有传-1", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "performanceId", value = "演出id", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "timeId", value = "场次id", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "ticketId", value = "票id", required = true),
    })
    public ResponseDto<CandyUseResultVo> useCoupon(@RequestParam("uCouponId") @NotNull @NotBlank String uCouponId,
                                                   @RequestParam("content") @NotNull @NotBlank String content,
                                                   @RequestParam("totalPrice") @NotNull String totalPrice,

                                                   @RequestParam("goodId") @NotNull @NotBlank String goodId,
                                                   @RequestParam("performanceId") @NotNull @NotBlank String performanceId,
                                                   @RequestParam("timeId") @NotNull @NotBlank String timeId,
                                                   @RequestParam("ticketId") @NotNull @NotBlank String ticketId
    ) {
        CandyUseResultVo result = candyCouponService.useCoupon(uCouponId, content, totalPrice, performanceId, timeId, ticketId, goodId);
        if (result == null) {
            return ResponseDto.failure();
        }
        result.setValue(result.getValue().setScale(2, BigDecimal.ROUND_HALF_UP));
        return ResponseDto.success(result);
    }

    //回退券
    @PostMapping("useBack")
    @ApiOperation("回退券")
    public ResponseDto<Boolean> useBackCoupon(@RequestBody @Valid List<BackCouponParam> backCouponParam) {
        if (backCouponParam.size() > 100) {
            return ResponseDto.failure("数据量不得大于100");
        }
        candyCouponService.useBackCoupon(backCouponParam);
        return ResponseDto.success();
    }

    @PostMapping("useBackJxl")
    @ApiOperation("回退券jxl")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "String", name = "uCouponIds", value = "uCouponIds", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "uid", value = "uid", required = true),
    })
    public ResponseDto<Boolean> useBackCoupon(
            @RequestParam("uCouponIds") @NotNull @NotBlank String uCouponIds,
            @RequestParam("uid") @NotNull @NotBlank String uid
    ) {
        BackCouponParam aNew = BackCouponParam.getNew();
        aNew.setuCouponIds(uCouponIds);
        aNew.setUid(uid);
        List<BackCouponParam> backCouponParam = new ArrayList<>();
        backCouponParam.add(aNew);

        if (backCouponParam.size() > 100) {
            return ResponseDto.failure("数据量不得大于100");
        }
        candyCouponService.useBackCoupon(backCouponParam);
        return ResponseDto.success();
    }

    //兑换券
    @PostMapping("receive")
    @ApiOperation("领取券")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "String", name = "ccode", value = "兑换码", required = true),
    })
    public ResponseDto<String> receiveCoupon(@RequestParam("ccode") @NotNull @NotBlank String ccode) {
        return candyCouponService.receiveCoupon(ccode);
//        if (result) {
//            return ResponseDto.success();
//        } else {
//            return ResponseDto.failure();
//        }
    }

    //兑换券详情
    @PostMapping("receive/details")
    @ApiOperation("领取券详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "String", name = "ccode", value = "兑换码", required = true),
    })
    public ResponseDto<CandyCouponVo> receiveCouponDetails(@RequestParam("ccode") @NotNull @NotBlank String ccode) {
        return candyCouponService.receiveCouponDetails(ccode);
//        if (result != null) {
//            return ResponseDto.success(result);
//        } else {
//            return ResponseDto.failure();
//        }
    }

    //根据券id获取券详情
    @PostMapping("receive/ListById")
    @ApiOperation("根据券id获取券详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "String", name = "uCouponIds", value = "券id(逗号隔开的字符串)", required = true),
    })
    public ResponseDto<List<CandyCouponVo>> couponListById(@RequestParam("uCouponIds") @NotNull @NotBlank String uCouponIds) {
        return candyCouponService.couponListById(uCouponIds);
//        if (result != null) {
//            return ResponseDto.success(result);
//        } else {
//            return ResponseDto.failure();
//        }
    }


    //要使用券列表 - 商品
    @PostMapping("preUse/goods/store")
    @ApiOperation("要使用券列表 - 商品[商铺]")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "BigDecimal", name = "priceTotal", value = "待支付总金额", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "skuIds", value = "商品id(逗号隔开的字符串)", required = true),
            @ApiImplicitParam(type = "form", dataType = "Integer", name = "type", value = "类型 1可用 2过期/已使用 ", required = true),
    })
    public ResponseDto<List<CandyCouponVo>> preUseGoodStore(@RequestParam("priceTotal") @NotNull BigDecimal priceTotal,
                                                            @RequestParam("skuIds") @NotNull @NotBlank String skuIds,
                                                            @RequestParam("type") @NotNull Integer type,
                                                            @RequestParam(required = false, name = "page") Integer page) {
        CandyMyCouponListVo vo = candyCouponService.preUseGoodCoupon(priceTotal, skuIds, type);
        List<CandyCouponVo> list = vo.getMyCoupon();
        List<CandyCouponVo> listVo = ObjectUtil.getCandyCouponVoArrayList();
        if (page == null || page == 0) {
            page = 1;
        }
        int size = 10;
        int initSize = (page - 1) * size;
        int forSize = page * size;
        if (forSize >= list.size()) {
            forSize = list.size();
        }
        for (int i = initSize; i < forSize; i++) {
            listVo.add(list.get(i));
        }
        return ResponseDto.success(listVo);
    }

    //是否可用券 - 商品
    @PostMapping("preCanUse/goods/store")
    @ApiOperation("是否可用券 - 商品[商铺]")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "BigDecimal", name = "priceTotal", value = "待支付总金额", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "goodId", value = "商品id(逗号隔开的字符串)", required = true)
    })
    public ResponseDto<HashMap<String, Integer>> preCanUseGoodStore(@RequestParam("priceTotal") @NotNull BigDecimal priceTotal,
                                                                    @RequestParam("skuIds") @NotNull @NotBlank String skuIds) {
        HashMap<String, Integer> hashMap = CollectionUtil.mapStringInteger();
        hashMap.put("canUse", candyCouponService.preCanUseGoodCoupon(priceTotal, skuIds));
        return ResponseDto.success(hashMap);
    }
}
