package com.liquidnet.service.goblin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.io.Serializable;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 商城-搭售活动
 * </p>
 *
 * @author liquidnet
 * @since 2022-06-30
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinMix implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 混合id
     */
    private String mixId;

    /**
     * 用户id
     */
    private String uid;

    /**
     * 混合名称
     */
    private String name;

    /**
     * 开始时间
     */
    private LocalDateTime timeStart;

    /**
     * 结束时间
     */
    private LocalDateTime timeEnd;

    /**
     * 状态[6-启用|7-停用]
     */
    private Integer status;

    /**
     * 展示位置[1-商城|2-数字藏品]
     */
    private Integer showPosition;

    /**
     * 售卖名称
     */
    private String sellName;

    /**
     * 快递价格
     */
    private BigDecimal expressPrice;

    /**
     * 商品简介/购买须知
     */
    private String intro;

    /**
     * 封面图片地址
     */
    private String coverPic;

    /**
     * 商品视频地址/数字昌平视频地址
     */
    private String video;

    /**
     * 商品详情/藏品详情
     */
    private String details;

    /**
     * 展示文件类型[1-图片|2-视频|3-模型]
     */
    private String watchType;

    /**
     * 数字藏品图片地址
     */
    private String detailUrl;

    /**
     * 库存
     */
    private Integer stock;

    /**
     * 锁定库存
     */
    private Integer stockLock;

    /**
     * 是否锁定库存[0-否|1-是]
     */
    private Integer isLock;

    /**
     * 限购数量[0-不限购]
     */
    private Integer limit;

    /**
     * 白名单类型[0-会员|1-指定用户|2-全部用户]
     */
    private Integer whiteType;

    /**
     * 白名单xls地址
     */
    private String whiteUrl;

    /**
     * IOS支付方式[0-第三方支付|1-苹果支付]
     */
    private Integer payType;

    /**
     * 是否删除[0-否|1-是]
     */
    private Integer delTag;

    /**
     * 补充字段
     */
    private String comment;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;


}
