package com.liquidnet.client.admin.zhengzai.goblin.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.zhengzai.goblin.service.IGoblinFrontMoudleIndexService;
import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.goblin.constant.GoblinRedisConst;
import com.liquidnet.service.goblin.entity.GoblinFrontMoudleIndex;
import com.liquidnet.service.goblin.mapper.GoblinFrontMoudleIndexMapper;
import com.liquidnet.service.goblin.param.GoblinFrontMoudleIndexParam;
import com.mongodb.BasicDBObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 组件排序 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2022-01-06
 */
@Service
public class GoblinFrontMoudleIndexServiceImpl extends ServiceImpl<GoblinFrontMoudleIndexMapper, GoblinFrontMoudleIndex> implements IGoblinFrontMoudleIndexService {
    @Autowired
    GoblinFrontMoudleIndexMapper goblinFrontMoudleIndexMapper;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private RedisDataSourceUtil redisDataSourceUtil;

    @Override
    public List<GoblinFrontMoudleIndexParam> listGoblinFrontMoudleIndex() {
        LambdaQueryWrapper<GoblinFrontMoudleIndex> queryWrapper = Wrappers.lambdaQuery(GoblinFrontMoudleIndex.class);
        queryWrapper.orderByAsc(GoblinFrontMoudleIndex::getIndexs);
        List<GoblinFrontMoudleIndex> list=goblinFrontMoudleIndexMapper.selectList(queryWrapper);
        List<GoblinFrontMoudleIndexParam> list1=new ArrayList<>();
        for(GoblinFrontMoudleIndex goblinFrontMoudleIndex:list){
            GoblinFrontMoudleIndexParam goblinFrontMoudleIndexParam=new GoblinFrontMoudleIndexParam();
            BeanUtils.copyProperties(goblinFrontMoudleIndex,goblinFrontMoudleIndexParam);
            list1.add(goblinFrontMoudleIndexParam);
        }
        return list1;
    }

    @Override
    public boolean upadteGoblinFrontMoudleIndex(GoblinFrontMoudleIndex goblinFrontMoudleIndex) {
        goblinFrontMoudleIndex.setUpdateTime(LocalDateTime.now());
        goblinFrontMoudleIndexMapper.updateById(goblinFrontMoudleIndex);
        return true;
    }

    public boolean online(){
        //查出数据
        LambdaQueryWrapper<GoblinFrontMoudleIndex> queryWrapper = Wrappers.lambdaQuery(GoblinFrontMoudleIndex.class);
        queryWrapper.ne(GoblinFrontMoudleIndex::getDelTag,1);
        queryWrapper.orderByAsc(GoblinFrontMoudleIndex::getIndexs);
        List<GoblinFrontMoudleIndex> list=goblinFrontMoudleIndexMapper.selectList(queryWrapper);
        if(list.size()>0){
            for(GoblinFrontMoudleIndex goblinFrontMoudleIndex:list){
                GoblinFrontMoudleIndex goblinFrontMoudleIndex1=mongoTemplate.findOne(Query.query(Criteria.where("moudleIndexId").is(goblinFrontMoudleIndex.getMoudleIndexId())), GoblinFrontMoudleIndex.class, GoblinFrontMoudleIndex.class.getSimpleName());
                if(null==goblinFrontMoudleIndex1){
                    mongoTemplate.save(goblinFrontMoudleIndex,GoblinFrontMoudleIndex.class.getSimpleName());
                }else{
                    BasicDBObject orderObject = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(goblinFrontMoudleIndex)));
                    mongoTemplate.getCollection(GoblinFrontMoudleIndex.class.getSimpleName()).updateOne(
                            Query.query(Criteria.where("moudleIndexId").is(goblinFrontMoudleIndex.getMoudleIndexId())).getQueryObject(),
                            orderObject
                    );
                }
            }
            // reids 存入
            redisDataSourceUtil.getRedisGoblinUtil().set(GoblinRedisConst.MOUDLE_INDEX,list);
        }
      //  List<GoblinFrontMoudleIndexParam> list=this.listGoblinFrontMoudleIndex();
        // mongodb 放入

        return  true;
    }

}
