package com.liquidnet.service.slime.service;

import com.liquidnet.service.slime.constant.SlimeAuthorizationConst;
import com.liquidnet.service.slime.dto.vo.*;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
public class SlimeMongoService {
    @Autowired
    MongoTemplate mongoTemplate;

    @Autowired
    MongoConverter mongoConverter;


    // 【场地相关】
    public SlimeFieldsVo getFieldsVoByFieldId(String fieldId) {
        Query query = Query.query(Criteria.where("fieldId").is(fieldId));
        return mongoTemplate.findOne(query, SlimeFieldsVo.class, SlimeFieldsVo.class.getSimpleName());
    }

    public void setFieldsVoByFieldId(String fieldId, SlimeFieldsVo vo) {
        Query query = Query.query(Criteria.where("fieldId").is(fieldId));
        Document document = (Document)mongoConverter.convertToMongoType(vo);
        Update update = Update.fromDocument(document);
        mongoTemplate.upsert(query, update, SlimeFieldsVo.class, SlimeFieldsVo.class.getSimpleName());
    }

    // 【场地申请相关】
    public List<SlimeFieldAppliesVo> getFieldAppliesVosByUid(String uid) {
        Query query = Query.query(Criteria.where("uid").is(uid).and("deletedAt").is(null));
        return mongoTemplate.find(query, SlimeFieldAppliesVo.class, SlimeFieldAppliesVo.class.getSimpleName());
    }

    public SlimeFieldAppliesVo addFieldAppliesVo(SlimeFieldAppliesVo vo) {
        return mongoTemplate.insert(vo, SlimeFieldAppliesVo.class.getSimpleName());
    }

    public void delFieldAppliesVoByFieldApplyId(String fieldApplyId) {
        Query query = Query.query(Criteria.where("fieldApplyId").is(fieldApplyId));
        mongoTemplate.remove(query, SlimeFieldAppliesVo.class.getSimpleName());
    }

    // 【默认验票员相关】
    public List<SlimeFieldCheckersVo> getFieldCheckersVosByFieldId(String fieldId) {
        Query query = Query.query(Criteria.where("fieldId").is(fieldId).and("deletedAt").is(null));
        return mongoTemplate.find(query, SlimeFieldCheckersVo.class, SlimeFieldCheckersVo.class.getSimpleName());
    }

    public SlimeFieldCheckersVo addFieldCheckersVo(SlimeFieldCheckersVo vo) {
        return mongoTemplate.insert(vo, SlimeFieldCheckersVo.class.getSimpleName());
    }

    public void delFieldCheckersVoByFieldCheckerId(String fieldCheckerId) {
        Query query = Query.query(Criteria.where("fieldCheckerId").is(fieldCheckerId));
        mongoTemplate.remove(query, SlimeFieldCheckersVo.class.getSimpleName());
    }


    // 【主办相关】
    public SlimeSponsorsVo getSponsorsVoBySponsorId(String sponsorId) {
        Query query = Query.query(Criteria.where("sponsorId").is(sponsorId));
        return mongoTemplate.findOne(query, SlimeSponsorsVo.class, SlimeSponsorsVo.class.getSimpleName());
    }

    public void setSponsorsVoBySponsorId(String sponsorId, SlimeSponsorsVo vo) {
        Query query = Query.query(Criteria.where("sponsorId").is(sponsorId));
        Document document = (Document)mongoConverter.convertToMongoType(vo);
        Update update = Update.fromDocument(document);
        mongoTemplate.upsert(query, update, SlimeSponsorsVo.class, SlimeSponsorsVo.class.getSimpleName());
    }

    // 【主办申请相关】
    public List<SlimeSponsorAppliesVo> getSponsorAppliesVosByUid(String uid) {
        Query query = Query.query(Criteria.where("uid").is(uid).and("deletedAt").is(null));
        return mongoTemplate.find(query, SlimeSponsorAppliesVo.class, SlimeSponsorAppliesVo.class.getSimpleName());
    }

    public SlimeSponsorAppliesVo addSponsorAppliesVo(SlimeSponsorAppliesVo vo) {
        return mongoTemplate.insert(vo, SlimeSponsorAppliesVo.class.getSimpleName());
    }

    public void delSponsorAppliesVoBySponsorApplyId(String sponsorApplyId) {
        Query query = Query.query(Criteria.where("sponsorApplyId").is(sponsorApplyId));
        mongoTemplate.remove(query, SlimeSponsorAppliesVo.class.getSimpleName());
    }


    // 【演出权限相关】
    public SlimeAuthorizationPerformanceVo getAuthorizationPerformanceVo(String performanceId, String uid) {
        Query query = Query.query(Criteria.where("performanceId").is(performanceId).and("uid").is(uid));
        return mongoTemplate.findOne(query, SlimeAuthorizationPerformanceVo.class, SlimeAuthorizationPerformanceVo.class.getSimpleName());
    }

    public SlimeAuthorizationPerformanceVo getAndSyncAuthorizationPerformanceVo(String performanceId, String uid) {
        // 聚合角色及权限
        Query recordsQuery = Query.query(Criteria.where("performanceId").is(performanceId).and("uid").is(uid).and("deletedAt").is(null));
        List<SlimeAuthorizationRecordsVo> authorizationRecordsVos = mongoTemplate.find(recordsQuery, SlimeAuthorizationRecordsVo.class, SlimeAuthorizationRecordsVo.class.getSimpleName());
        List<String> uidRoles = new ArrayList<>();
        List<String> permissionIds = new ArrayList<>();
        for (SlimeAuthorizationRecordsVo authorizationRecordsVo: authorizationRecordsVos) {
            if (!uidRoles.contains(authorizationRecordsVo.getUidRole())) {
                uidRoles.add(authorizationRecordsVo.getUidRole());
            }
            for (SlimeAuthorizationPermissionsVo authorizationPermissionsVo: authorizationRecordsVo.getPermissionsVos()) {
                if (!permissionIds.contains(authorizationPermissionsVo.getPermissionId())) {
                    permissionIds.add(authorizationPermissionsVo.getPermissionId());
                }
            }
        }
        SlimeAuthorizationPerformanceVo vo = SlimeAuthorizationPerformanceVo.getNew();
        vo.setUid(uid);
        vo.setPerformanceId(performanceId);
        vo.setUidRoles(uidRoles);
        vo.setPermissionIds(permissionIds);
        Query query = Query.query(Criteria.where("performanceId").is(performanceId).and("uid").is(uid));
        Document document = (Document)mongoConverter.convertToMongoType(vo);
        Update update = Update.fromDocument(document);
        mongoTemplate.upsert(query, update, SlimeAuthorizationPerformanceVo.class, SlimeAuthorizationPerformanceVo.class.getSimpleName());
        return vo;
    }


    // 【授权记录相关】
    public SlimeAuthorizationRecordsVo getAuthorizationRecordsVoByAuthorizationRecordId(String authorizationRecordId) {
        Query query = Query.query(Criteria.where("authorizationRecordId").is(authorizationRecordId).and("deletedAt").is(null));
        return mongoTemplate.findOne(query, SlimeAuthorizationRecordsVo.class, SlimeAuthorizationRecordsVo.class.getSimpleName());
    }

    public List<SlimeAuthorizationRecordsVo> getAuthorizationRecordsVosByUid(String uid, String performanceId) {
        Query query = Query.query(Criteria.where("uid").is(uid).and("performanceId").is(performanceId).and("deletedAt").is(null));
        return mongoTemplate.find(query, SlimeAuthorizationRecordsVo.class, SlimeAuthorizationRecordsVo.class.getSimpleName());
    }

    public List<SlimeAuthorizationRecordsVo> getAuthorizationRecordsCheckersVosByCuid(String cuid, String performanceId) {
        Query query = Query.query(Criteria.where("uidRole").is(SlimeAuthorizationConst.PerformanceRole.CHECKER.getRole()).and("cuid").is(cuid).and("performanceId").is(performanceId).and("deletedAt").is(null));
        return mongoTemplate.find(query, SlimeAuthorizationRecordsVo.class, SlimeAuthorizationRecordsVo.class.getSimpleName());
    }
}
