package com.liquidnet.service.kylin.service.partner;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dao.ChildDetailsDao;
import com.liquidnet.service.kylin.dao.ChildListDao;
import com.liquidnet.service.kylin.entity.KylinCheckUser;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;

/**
 * <p>
 * 验票用户表 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-21
 */
public interface IKylinCheckUserPartnerService extends IService<KylinCheckUser> {

    // 子账号列表
    PageInfo<ChildListDao> getCheckUserList(String merchantId, String mobile, int page, int size);

    // 子账号删除
    ResponseDto<String> del(String merchantId,String checkUserId);

    // 子账号创建
    ResponseDto<String> create(String merchantId,String name,String pwd,String mobile);

    // 子账号修改
    ResponseDto<String> change(String merchantId,String checkUserId,String name,String pwd,String mobile);

    // 子账号详情
    ResponseDto<ChildDetailsDao> details(String merchantId, String checkUserId);
}
