package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

@Api
@Data
public class CouponCountVo implements Serializable, Cloneable {
    @ApiModelProperty(dataType = "String", name = "storeCouponIds", value = "券ID",example = "1",required = true)
    @NotNull @NotBlank
    private String storeCouponId;
    @ApiModelProperty(dataType = "Integer", name = "count", value = "领取数量",example = "10",required = true)
    @NotNull @NotBlank
    private Integer count;

    private static final CouponCountVo obj = new CouponCountVo();

    public static CouponCountVo getNew() {
        try {
            return (CouponCountVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new CouponCountVo();
    }
}
