package com.liquidnet.service.sweet.service.impl.five;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.entity.SweetManualShopFive;
import com.liquidnet.service.sweet.mapper.SweetManualShopFiveMapper;
import com.liquidnet.service.sweet.service.five.ISweetManualShopFiveService;
import com.liquidnet.service.sweet.utils.RedisFiveDataUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 电子宣传手册商铺表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-09
 */
@Service
public class SweetManualShopFiveServiceImpl extends ServiceImpl<SweetManualShopFiveMapper, SweetManualShopFive> implements ISweetManualShopFiveService {

    @Autowired
    private SweetManualShopFiveMapper sweetManualShopFiveMapper;
    @Autowired
    private RedisFiveDataUtils redisDataUtils;

    @Override
    public ResponseDto<List<SweetManualShopFive>> getList(String manualId, Integer type) {
        try {
            List<SweetManualShopFive> data = sweetManualShopFiveMapper.selectList(Wrappers.lambdaQuery(SweetManualShopFive.class).eq(SweetManualShopFive::getManualId, manualId).eq(SweetManualShopFive::getType, type).eq(SweetManualShopFive::getStatus, 1));
            return ResponseDto.success(data);
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<SweetManualShopFive> details(String manualShopId) {
        try {
            SweetManualShopFive data = sweetManualShopFiveMapper.selectOne(Wrappers.lambdaQuery(SweetManualShopFive.class).eq(SweetManualShopFive::getManualShopId, manualShopId).eq(SweetManualShopFive::getStatus, 1));
            return ResponseDto.success(data);
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> add(String manualId, String title, String picUrl, String describe, Integer type, Integer isRecommend, Integer sort) {
        try {
            SweetManualShopFive sweetManualShop = SweetManualShopFive.getNew();
            sweetManualShop.setManualShopId(IDGenerator.nextSnowId());
            sweetManualShop.setManualId(manualId);
            sweetManualShop.setTitle(title);
            sweetManualShop.setPicUrl(picUrl);
            sweetManualShop.setDescribes(describe);
            sweetManualShop.setType(type);
            sweetManualShop.setIsRecommend(isRecommend);
            sweetManualShop.setSort(sort);
            sweetManualShop.setStatus(1);
            sweetManualShopFiveMapper.insert(sweetManualShop);
            redisDataUtils.setManualShopRedisData(manualId);
            return ResponseDto.success();
        } catch (Exception e) {
            e.printStackTrace();
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> change(String manualShopId,String manualId, String title, String picUrl, String describe, Integer type, Integer isRecommend, Integer sort) {
        try {
            SweetManualShopFive sweetManualShop = SweetManualShopFive.getNew();
            sweetManualShop.setTitle(title);
            sweetManualShop.setPicUrl(picUrl);
            sweetManualShop.setDescribes(describe);
            sweetManualShop.setType(type);
            sweetManualShop.setIsRecommend(isRecommend);
            sweetManualShop.setSort(sort);
            sweetManualShopFiveMapper.update(sweetManualShop, Wrappers.lambdaUpdate(SweetManualShopFive.class).eq(SweetManualShopFive::getManualShopId, manualShopId));
            redisDataUtils.setManualShopRedisData(manualId);
            return ResponseDto.success();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> delete(String manualShopId,String manualId) {
        try {
            SweetManualShopFive sweetManualShop = SweetManualShopFive.getNew();
            sweetManualShop.setStatus(0);
            sweetManualShopFiveMapper.update(sweetManualShop, Wrappers.lambdaUpdate(SweetManualShopFive.class).eq(SweetManualShopFive::getManualShopId, manualShopId));
            redisDataUtils.setManualShopRedisData(manualId);
            return ResponseDto.success();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

}
