package com.liquidnet.service.platform.param.ticketSystem;

import com.liquidnet.service.platform.vo.ticketSystem.OrderVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(value = "STInsertOrderParam",description = "详情")
public class STInsertOrderParam {
    @ApiModelProperty(value = "订单id [必传]")
    String orderId;
    @ApiModelProperty(value = "下单时间 [必传]")
    LocalDateTime orderTime;
    @ApiModelProperty(value = "渠道类型，1自销，2分销 [必传]")
    Integer channelType;
    @ApiModelProperty(value = "渠道名称 [必传]")
    String channelName;
    @ApiModelProperty(value = "购票数量 [必传]")
    Integer ticketNum;
    @ApiModelProperty(value = "订单总金额，单位分，订单实收金额 [必传]")
    long totalAmount;
    @ApiModelProperty(value = "出票类型1：正常票，2：工作票，3：赠票 [必传]")
    Integer ticketType;
    @ApiModelProperty(value = "出票方式, 1纸制票，2 电子票 [必传]")
    Integer ticketMode;
    @ApiModelProperty(value = "实名方式,1 非实名，2一单一证，3一票一证 [必传]")
    Integer authMode;
    @ApiModelProperty(value = "票单List，多个票用英文逗号分隔 [必传]")
    List<OrderVo> ticketOrderList;
}