package com.liquidnet.service.dragon.channel.strategy.biz;

import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.dragon.bo.PayNotifyReqBo;
import com.liquidnet.service.dragon.constant.DragonConstant;
import com.liquidnet.service.dragon.dto.DragonOrdersDto;
import com.liquidnet.service.dragon.dto.DragonPayBaseReqDto;
import com.liquidnet.service.dragon.dto.DragonPayBaseRespDto;
import com.liquidnet.service.dragon.dto.PayNotifyDto;
import com.liquidnet.service.dragon.entity.DragonOrders;
import com.liquidnet.service.dragon.utils.DataUtils;
import com.liquidnet.service.dragon.utils.MqHandleUtil;
import org.springframework.beans.factory.annotation.Autowired;

import java.time.LocalDateTime;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: DragonPayBiz
 * @Package com.liquidnet.service.dragon.channel.strategy.biz
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/7/14 14:12
 */
public abstract class DragonPayBiz {
    @Autowired
    private MqHandleUtil mqHandleUtil;

    @Autowired
    private DataUtils dataUtils;

    public DragonOrders buildPayOrders(DragonPayBaseReqDto dragonPayBaseReqDto, DragonPayBaseRespDto respDto){
        //构造订单
        DragonOrders orders = new DragonOrders();
//        orders.setMid();
        orders.setStatus(Integer.valueOf(DragonConstant.PayStatusEnum.STATUS_UNPAID.getCode()));
        orders.setCode(respDto.getCode());
        orders.setType(dragonPayBaseReqDto.getType());
        orders.setPrice(dragonPayBaseReqDto.getPrice());
        orders.setName(dragonPayBaseReqDto.getName());
        orders.setDetail(dragonPayBaseReqDto.getDetail());
        orders.setOrderCode(dragonPayBaseReqDto.getOrderCode());
        orders.setClientIp(dragonPayBaseReqDto.getClientIp());
        orders.setNotifyUrl(dragonPayBaseReqDto.getNotifyUrl());
        orders.setPaymentType(DragonConstant.PayTypeEnum.PAYMENT_TYPE_APP_IAP.getCode());
//        orders.setPaymentId();
        orders.setPaymentAt(LocalDateTime.now());
//        orders.setFinishedAt();
        orders.setCreatedAt(LocalDateTime.now());
//        orders.setUpdatedAt();

        DragonOrdersDto ordersDto = new DragonOrdersDto();
        BeanUtil.copy(orders,ordersDto);
        //放到redis缓存中
        dataUtils.createPayOrder(orders.getOrderCode(),orders.getCode(),ordersDto);
        // 持久化到数据库
        boolean insertResult = mqHandleUtil.sendMySqlRedis(
                SqlMapping.get("dragon_orders.insert"),
                new Object[]{orders.getStatus(), orders.getCode(), orders.getType()
                        , orders.getPrice(), orders.getName(), orders.getDetail()
                        , orders.getOrderCode(), orders.getClientIp()
                        , orders.getNotifyUrl(), orders.getPaymentType(),
                        orders.getPaymentId(), orders.getPaymentAt()
                        , orders.getFinishedAt(), orders.getCreatedAt()
                        , orders.getUpdatedAt()}
        );
        return orders;
    }

     public PayNotifyReqBo buildPayNotifyReqBo(DragonOrdersDto dragonOrdersDto){
        PayNotifyReqBo payNotifyReqBo = new PayNotifyReqBo();
        payNotifyReqBo.setNotifyUrl(dragonOrdersDto.getNotifyUrl());
        PayNotifyDto payNotifyDto = new PayNotifyDto();
        payNotifyDto.setStatus(dragonOrdersDto.getStatus());
        payNotifyDto.setType(dragonOrdersDto.getType());
        payNotifyDto.setCode(dragonOrdersDto.getCode());
        payNotifyDto.setPaymentId(dragonOrdersDto.getPaymentId());
        payNotifyDto.setOrderCode(dragonOrdersDto.getOrderCode());
        payNotifyDto.setPrice(dragonOrdersDto.getPrice());
        payNotifyDto.setPaymentType(dragonOrdersDto.getPaymentType());
        payNotifyReqBo.setPayNotifyDto(payNotifyDto);
        return payNotifyReqBo;
    }
}
