package com.liquidnet.service.adam.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

@ApiModel(value = "AdamUserInfoVo", description = "用户详情")
public class AdamUserInfoVo implements java.io.Serializable, Cloneable {
    private static final long serialVersionUID = 8479869354894030303L;
    @ApiModelProperty(position = 10, value = "用户ID[64]")
    private String uid;
    @ApiModelProperty(position = 11, value = "手机号[20]")
    private String mobile;
    @ApiModelProperty(position = 12, value = "登录密码[64]，只针对PHP老用户，新用户无此功能")
    private String passwd;
//    @ApiModelProperty(position = 13, value = "支付密码[30]，暂无此功能")
//    private String payCode;
    @ApiModelProperty(position = 14, value = "昵称[32]")
    private String nickname;
    @ApiModelProperty(position = 15, value = "状态[1-正常,2-注销]")
    private Integer state;
    @ApiModelProperty(position = 16, value = "性别[32]")
    private AdamTagVo sex;
    @ApiModelProperty(position = 17, value = "生日[YYYY-MM-DD]")
    private String birthday;
    @ApiModelProperty(position = 18, value = "常住地/区域")
    private String area;
    @ApiModelProperty(position = 19, value = "个性签名")
    private String signature;
    @ApiModelProperty(position = 20, value = "头像")
    private String avatar;
    @ApiModelProperty(position = 21, value = "背景图")
    private String background;
    @ApiModelProperty(position = 22, value = "标签")
    private List<AdamTagParentVo> tagMe;
    @ApiModelProperty(position = 23, value = "注册时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime createAt;
    @ApiModelProperty(position = 24, value = "最近一次更新时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime updatedAt;
    @ApiModelProperty(position = 25, value = "注销时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime closedAt;
    @ApiModelProperty(position = 26, value = "完善信息进度[0-未完善,1-已完善]")
    private Integer isComplete;
    @ApiModelProperty(position = 27, value = "")
    private String rongCloudToken;
    @ApiModelProperty(position = 28, value = "身份二维码")
    private String qrCode;

    private static final AdamUserInfoVo obj = new AdamUserInfoVo();

    public static AdamUserInfoVo getNew() {
        try {
            return (AdamUserInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new AdamUserInfoVo();
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getPasswd() {
        return passwd;
    }

    public void setPasswd(String passwd) {
        this.passwd = passwd;
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public AdamTagVo getSex() {
        return sex;
    }

    public void setSex(AdamTagVo sex) {
        this.sex = sex;
    }

    public String getBirthday() {
        return birthday;
    }

    public void setBirthday(String birthday) {
        this.birthday = birthday;
    }

    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getSignature() {
        return signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getAvatar() {
        return avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public String getBackground() {
        return background;
    }

    public void setBackground(String background) {
        this.background = background;
    }

    public List<AdamTagParentVo> getTagMe() {
        return tagMe;
    }

    public void setTagMe(List<AdamTagParentVo> tagMe) {
        this.tagMe = tagMe;
    }

    public LocalDateTime getCreateAt() {
        return createAt;
    }

    public void setCreateAt(LocalDateTime createAt) {
        this.createAt = createAt;
    }

    public LocalDateTime getUpdatedAt() {
        return updatedAt;
    }

    public void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public LocalDateTime getClosedAt() {
        return closedAt;
    }

    public void setClosedAt(LocalDateTime closedAt) {
        this.closedAt = closedAt;
    }

    public Integer getIsComplete() {
        return isComplete;
    }

    public void setIsComplete(Integer isComplete) {
        this.isComplete = isComplete;
    }

    public String getRongCloudToken() {
        return rongCloudToken;
    }

    public void setRongCloudToken(String rongCloudToken) {
        this.rongCloudToken = rongCloudToken;
    }

    public String getQrCode() {
        return qrCode;
    }

    public void setQrCode(String qrCode) {
        this.qrCode = qrCode;
    }
}
