package com.liquidnet.service.goblin.dto.vo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 订单单品表
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinOrderSkuVo implements Serializable, Cloneable {

    @ApiModelProperty(value = "订单sku_id")
    private String orderSkuId;
    @ApiModelProperty(value = "订单id")
    private String orderId;
    @ApiModelProperty(value = "商品id")
    private String spuId;
    @ApiModelProperty(value = "款式id")
    private String skuId;
    @ApiModelProperty(value = "数量")
    private Integer num;
    @ApiModelProperty(value = "款式原价")
    private BigDecimal skuPrice;
    @ApiModelProperty(value = "款式实付价")
    private BigDecimal skuPriceActual;
    @ApiModelProperty(value = "退款价格")
    private BigDecimal priceRefund;
    @ApiModelProperty(value = "款式名称")
    private String skuName;
    @ApiModelProperty(value = "款式编号")
    private String skuNo;
    @ApiModelProperty(value = "款式图片")
    private String skuImage;
    @ApiModelProperty(value = "款式规格")
    private String skuSpecs;
    @ApiModelProperty(value = "管理员优惠价格")
    private BigDecimal priceModify;
    @ApiModelProperty(value = "款式最终优惠价")
    private BigDecimal priceVoucher;
    @ApiModelProperty(value = "创建时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;

    private static final GoblinOrderSkuVo obj = new GoblinOrderSkuVo();

    public static GoblinOrderSkuVo getNew() {
        try {
            return (GoblinOrderSkuVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinOrderSkuVo();
        }
    }
}
