package com.liquidnet.service.adam.dto.vo;

import com.liquidnet.service.kylin.dto.vo.KylinPerformanceVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "AdamDisposedBaseVo", description = "想去基础数据")
@Data
public class AdamDisposedBaseVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 3910252748178007996L;
    @ApiModelProperty(position = 10, value = "用户ID[64]")
    private String uid;
    @ApiModelProperty(position = 11, value = "用户头像[255]")
    private String avatar;
    @ApiModelProperty(position = 12, value = "用户昵称[32]")
    private String nickname;
    @ApiModelProperty(position = 13, value = "用户性别[32]")
    private AdamTagVo sex;
    @ApiModelProperty(position = 14, value = "内容ID[64]")
    private String contentId;
    @ApiModelProperty(position = 15, value = "内容类型")
    private String type;
    @ApiModelProperty(position = 16, value = "内容类型")
    private Integer state;
    @ApiModelProperty(position = 17, value = "收藏时间")
    private String createdAt;
    @ApiModelProperty(position = 18, value = "更新时间")
    private String updatedAt;
    @ApiModelProperty(position = 19, value = "展示信息")
    private KylinPerformanceVo contentInfo;

    private static final AdamDisposedBaseVo obj = new AdamDisposedBaseVo();

    public static AdamDisposedBaseVo getNew() {
        try {
            return (AdamDisposedBaseVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdamDisposedBaseVo();
        }
    }
}
