package com.liquidnet.service.bank.common;

import com.liquidnet.common.exception.properties.ErrorCodeProperties;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * @author LiChen
 * @date 2020/11/4 5:39 下午
 */
public enum BankErrorCode {
    SUCCESS("0"),
    BANK_CC_001001("BANK_CC_001001"),
    ;

    BankErrorCode(String code) {
        this.code = code;
    }

    private String code;

    private static final Map<String, BankErrorCode> valueMap;

    static {
        Map<String, BankErrorCode> errorMap = new HashMap<>();
        for (BankErrorCode errorCode : BankErrorCode.values()) {
            errorMap.put(errorCode.code, errorCode);
        }
        valueMap = Collections.unmodifiableMap(errorMap);
    }

    public static BankErrorCode getErrorCode(String code) {
        return valueMap.get(code);
    }

    public String getCode() {
        return this.code;
    }

    public String getVal() {
        return ErrorCodeProperties.getValue(this.code);
    }
}
