package com.liquidnet.service.reconciliation.strategy.accounting;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description: 对账逻辑
 * @class: ComparingAccountStrategyContext
 * @Package com.liquidnet.service.reconciliation.strategy.transtype
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/10/27 14:35
 */
@Component
public class ComparingAccountStrategyContext {
    private final Map<String, IComparingAccountStrategy> handlerMap = new HashMap<>();

    public IComparingAccountStrategy getStrategy(String type) {
        return handlerMap.get(type);
    }

    public void putStrategy(String code, IComparingAccountStrategy strategy) {
        handlerMap.put(code, strategy);
    }
}
