package com.liquidnet.service.goblin.param;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 秒杀表
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-30
 */
@Data
@ApiModel(value = "GoblinFrontSeckillBuildParam", description = "秒杀表")
public class GoblinFrontSeckillBuildParam implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @ApiModelProperty(value = "主键")
    private Long mid;

    /**
     * 官方活动id
     */
    @ApiModelProperty(value = "活动id(官方g_,商铺s_)，按照顺序添加")
    private String selfActivityids;

    /**
     * 1、一行三个2、两行三个
     */
    @ApiModelProperty(value = "1、一行三个2、两行三个")
    private Integer showType;

    /**
     * 1、关闭模块2、保留模块
     */
    @ApiModelProperty(value = "1、关闭模块2、保留模块")
    private Integer activityType;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern=DateUtil.DATE_FULL_STR)
    private LocalDateTime createTime;

    /**
     * 修改时间
     */
    @ApiModelProperty(value = "修改时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime updateTime;

    /**
     * 0未删除1已删除
     */
    @ApiModelProperty(value = "0未删除1已删除")
    private Integer delTag;

    /**
     * 排序
     */
    @ApiModelProperty(value = "忽略")
    private Integer indexs;

    /**
     * 秒杀id
     */
    @ApiModelProperty(value = "秒杀id")
    private String seckilId;

    //活动
    public List<Map> acityList;

    private static final GoblinFrontSeckillBuildParam obj = new GoblinFrontSeckillBuildParam();

    public static GoblinFrontSeckillBuildParam getNew() {
        try {
            return (GoblinFrontSeckillBuildParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinFrontSeckillBuildParam();
        }
    }


}
