package com.liquidnet.service.goblin.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.List;

@Data
public class GoblinListCreateParam {
    @ApiModelProperty(value = "优先购名称")
    @NotNull(message = "优先购名称不能为空")
    private String name;
    @ApiModelProperty(value = "优先购类型[0-会员|1-指定用户]")
    @NotNull(message = "优先购类型不能为空")
    private String whiteType;
    @ApiModelProperty(value = "优先购文件地址")
    private String whiteUrl;
    @ApiModelProperty(value = "优先购提前时间")
    @NotNull(message = "优先购提前时间不能为空")
    private String advanceMin;
    @ApiModelProperty(value = "黑名单文件地址")
    private String blackUrl;
    @ApiModelProperty(value = "商品数据")
    private List<GoblinListCreateItemParam> itemParams;
}
