package com.liquidnet.service.feign.kylin.task;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.vo.KylinPerformanceVo;
import feign.hystrix.FallbackFactory;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@Component
@FeignClient(name = "liquidnet-service-kylin",
        contextId = "FeignKylinTaskClient", path = "",
        fallback = FallbackFactory.Default.class)
public interface FeignKylinTaskClient {

    @PostMapping("order/checkOrderTime")
    ResponseDto<Boolean> checkOrderTime();

    @PostMapping("performance/checkPerformanceTime")
    ResponseDto<String> checkPerformanceTime();
}
