package com.liquidnet.service.sweet.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.sweet.dto.param.SweetYbEnrollParam;
import com.liquidnet.service.sweet.entity.SweetAnswer;
import com.liquidnet.service.sweet.entity.SweetYbEnroll;
import com.liquidnet.service.sweet.mapper.SweetYbEnrollMapper;
import com.liquidnet.service.sweet.service.ISweetYbEnrollService;
import com.liquidnet.service.sweet.utils.QueueUtils;
import com.liquidnet.service.sweet.utils.RedisDataUtils;
import com.liquidnet.service.sweet.vo.SweetAnswerVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.LinkedList;

/**
 * <p>
 * YB报名表 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-07-29
 */
@Service
public class SweetYbEnrollServiceImpl extends ServiceImpl<SweetYbEnrollMapper, SweetYbEnroll> implements ISweetYbEnrollService {

    @Autowired
    QueueUtils queueUtils;

    @Override
    public ResponseDto<Boolean> create(SweetYbEnrollParam param) {
        LinkedList<String> sqls = CollectionUtil.linkedListString();
        LinkedList<Object[]> sqlsDataA = CollectionUtil.linkedListObjectArr();
        sqls.add(SqlMapping.get("sweet_yb_enroll.insert"));
        sqlsDataA.add(new Object[]{
                IDGenerator.nextSnowId(), param.getContactTell(),
                param.getContactWechat(), param.getNickname(), param.getStyle(),
                param.getImgUrl(), param.getAudioUrl(), param.getUniversities(),
        });
        queueUtils.sendMsgByRedis(MQConst.SweetQueue.SWEET_ANSWER_INSERT.getKey(),
                SqlMapping.gets(sqls, sqlsDataA));

        return ResponseDto.success(true);
    }
}
