package com.liquidnet.service.goblin.controller;


import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.manage.vo.HelpValueVo;
import com.liquidnet.service.goblin.service.IGoblinGoodsAnticipateService;
import io.swagger.annotations.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 预约表 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2022-04-07
 */
@Slf4j
@RestController
@Api(tags = "预约相关(前)")
@RequestMapping("/anticipate")
public class GoblinGoodsAnticipateController {

    @Autowired
    IGoblinGoodsAnticipateService goblinGoodsAnticipateService;

    @ApiOperation("用户预约 （只能预约不能取消）")
    @PostMapping("/userAbout")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "skuId", value = "skuId"),
    })
    public ResponseDto<Boolean> userAbout(@RequestParam(name = "skuId") String skuId) {
        return goblinGoodsAnticipateService.userAbout(skuId);
    }

    @ApiOperation("根据skuId是否预约")
    @GetMapping("/selectAnticipateBySkuIdAndUid")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "skuId", value = "skuId"),
    })
    public ResponseDto<Boolean> selectAnticipate(@RequestParam(name = "skuId") String skuId) {
        return goblinGoodsAnticipateService.selectAnticipate(skuId);
    }

    @ApiOperation("用户分享,根据sku发起助力")
    @PostMapping("/share")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "skuId", value = "skuId"),
    })
    public ResponseDto<String> share(@RequestParam(name = "skuId") String skuId) {
        return goblinGoodsAnticipateService.share(skuId);
    }

    @ApiOperation("用户为他人助力")
    @PostMapping("help")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "sid", value = "创建分享生成的sid"),
    })
    @ApiResponses({
            @ApiResponse(code = 0, message = "助力成功"),
            @ApiResponse(code = 150001, message = "本人为本人助力"),
            @ApiResponse(code = 150002, message = "重复助力"),
            @ApiResponse(code = 150003, message = "分享不存在"),
            @ApiResponse(code = 150004, message = "助力已结束")
    })
    public ResponseDto<String> help(@RequestParam(name = "sid") String sid) {
        return goblinGoodsAnticipateService.help(sid);
    }

    @ApiOperation("查询用户是否助力该分享")
    @GetMapping("helpSid")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "sid", value = "创建分享生成的sid"),
    })
    public ResponseDto<Boolean> helpSid(@RequestParam(name = "sid") String sid) {
        return goblinGoodsAnticipateService.helpSid(sid);
    }

    @ApiOperation("获取当前助力信息")
    @PostMapping("getHelpValue")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "sid", value = "创建分享生成的sid"),
    })
    public ResponseDto<HelpValueVo> getHelpValue(@RequestParam(name = "sid") String sid) {
        return goblinGoodsAnticipateService.getHelpValue(sid);
    }

    @ApiOperation("是否开启助力(返回助力的sid,返回null则没有开启助力)")
    @GetMapping("getTurnOnHelp")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "skuId", value = "skuId"),
    })
    public ResponseDto<String> getTurnOnHelp(@RequestParam(name = "skuId") String skuId) {
        return goblinGoodsAnticipateService.getTurnOnHelp(skuId);
    }

    @ApiOperationSupport(order = 6)
    @ApiOperation(value = "混合购【用户预约MIX混合购】")
    @GetMapping("reserveByMix")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "mixId", value = "混合售id"),
    })
    public ResponseDto<Boolean> reserveByMix(@RequestParam(value = "mixId", required = true) String mixId) {
        return goblinGoodsAnticipateService.reserveByMix(mixId);
    }

}
