package com.liquidnet.service.adam.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.adam.dto.AdamMemberOrderDto;
import com.liquidnet.service.adam.entity.AdamMemberOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@ApiModel(value = "AdamMemberOrderVo", description = "订单详情展示")
@Data
public class AdamMemberOrderVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -1606153856097622877L;
    @ApiModelProperty(position = 0, value = "订单号")
    private String orderNo;
    @ApiModelProperty(position = 1, value = "用户uid")
    private String uid;
    @ApiModelProperty(position = 2, value = "购买方式:0-购买会员,1-购买会员码,2-会员码,3-礼包码")
    private Integer mode;
    @ApiModelProperty(position = 3, value = "会员id")
    private String memberId;
    @ApiModelProperty(position = 4, value = "会员名")
    private String memberName;
    @ApiModelProperty(position = 5, value = "会员价格id")
    private String memberPriceId;
    @ApiModelProperty(position = 6, value = "购买天数")
    private Integer days;
    @ApiModelProperty(position = 7, value = "订单状态:0-未支付,1-已支付,2-已关闭,3-超时付,4-退款中,5-已退款")
    private Integer state;
    @ApiModelProperty(position = 8, value = "会员号")
    private String memberNo;
    @ApiModelProperty(position = 9, value = "会员生日[yyyy-MM-dd]")
    private String birthday;
    @ApiModelProperty(position = 10, value = "支付终端", allowableValues = "app,wap,js,applet")
    private String deviceFrom;
    @ApiModelProperty(position = 11, value = "支付方式", allowableValues = "alipay,wepay")
    private String payType;
    @ApiModelProperty(position = 12, value = "支付单号")
    private String payNo;
    @ApiModelProperty(position = 13, value = "支付时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime paymentAt;
    @ApiModelProperty(position = 14, value = "创建时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;
    @ApiModelProperty(position = 15, value = "创建时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime updatedAt;
    @ApiModelProperty(position = 16, value = "价格")
    private BigDecimal price;
    @ApiModelProperty(position = 17, value = "实付价格")
    private BigDecimal pricePaid;
    @ApiModelProperty(position = 18, value = "客户端IP")
    private String clientIp;
    @ApiModelProperty(position = 19, value = "客户端来源")
    private String source;
    @ApiModelProperty(position = 20, value = "客户端版本")
    private String version;

    @ApiModelProperty(position = 21, value = "会员订单扩展信息")
    private AdamMemberOrderExtVo extendVo;

    @ApiModelProperty(position = 30, value = "会员须知")
    private String memberNotes;
    @ApiModelProperty(position = 31, value = "会员码信息")
    private AdamMemberCodeVo memberCodeVo;

    public static final AdamMemberOrderVo obj = new AdamMemberOrderVo();

    public static AdamMemberOrderVo getNew() {
        try {
            return (AdamMemberOrderVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdamMemberOrderVo();
        }
    }

    public AdamMemberOrderVo copy(AdamMemberOrderDto source) {
        if (null == source) return this;
        this.setOrderNo(source.getOrderNo());
        this.setUid(source.getUid());
        this.setMode(source.getMode());
        this.setMemberId(source.getMemberId());
        this.setMemberName(source.getMemberName());

        this.setMemberPriceId(source.getMemberPriceId());
        this.setDays(source.getDays());
        this.setState(source.getState());
        this.setMemberNo(source.getMemberNo());
        this.setBirthday(source.getBirthday());

        this.setDeviceFrom(source.getDeviceFrom());
        this.setPayType(source.getPayType());
        this.setPayNo(source.getPayNo());
        this.setPaymentAt(source.getPaymentAt());
        this.setCreatedAt(source.getCreatedAt());

        this.setUpdatedAt(source.getUpdatedAt());
        this.setPrice(source.getPrice());
        this.setPricePaid(source.getPricePaid());
        this.setClientIp(source.getClientIp());
        this.setSource(source.getSource());

        this.setVersion(source.getVersion());

        AdamMemberOrderExtVo extVo = AdamMemberOrderExtVo.getNew();
        extVo.setOrderNo(source.getOrderNo());
        extVo.setExpressStatus(source.getExpressStatus());
        extVo.setExpressReceiver(source.getExpressReceiver());
        extVo.setExpressPhone(source.getExpressPhone());
        extVo.setExpressAddress(source.getExpressAddress());
        this.setExtendVo(extVo);
        return this;
    }

    public AdamMemberOrderVo copy(AdamMemberOrder source) {
        if (null == source) return this;
        this.setOrderNo(source.getOrderNo());
        this.setUid(source.getUid());
        this.setMode(source.getMode());
        this.setMemberId(source.getMemberId());
        this.setMemberName(source.getMemberName());
        this.setMemberPriceId(source.getMemberPriceId());
        this.setDays(source.getDays());
        this.setState(source.getState());
        this.setMemberNo(source.getMemberNo());
        this.setBirthday(source.getBirthday());
        this.setDeviceFrom(source.getDeviceFrom());
        this.setPayType(source.getPayType());
        this.setPayNo(source.getPayNo());
        this.setPaymentAt(source.getPaymentAt());
        this.setCreatedAt(source.getCreatedAt());
        this.setUpdatedAt(source.getUpdatedAt());
        this.setPrice(source.getPrice());
        this.setPricePaid(source.getPricePaid());
        this.setClientIp(source.getClientIp());
        this.setSource(source.getSource());
        this.setVersion(source.getVersion());
        return this;
    }
}
