package com.liquidnet.service.sweet.handler;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.sweet.config.WechatMpConfigure;
import com.liquidnet.service.sweet.entity.SweetWechatUser;
import com.liquidnet.service.sweet.service.impl.SweetWechatTemplateServiceImpl;
import com.liquidnet.service.sweet.utils.QueueUtils;
import com.liquidnet.service.sweet.utils.RedisDataUtils;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.mp.api.WxMpMessageHandler;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.LinkedList;
import java.util.Map;

/**
 * <p>
 * 关注
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-07-31 5:06 下午
 */
@Component
@Slf4j
public class SubscribeHandler implements WxMpMessageHandler {
    @Autowired
    private RedisDataUtils redisDataUtils;
    @Autowired
    private QueueUtils queueUtils;
    @Autowired
    WechatMpConfigure wechatMpConfigure;

    @Autowired
    private SweetWechatTemplateServiceImpl sweetWechatTemplateService;

    @Override
    public WxMpXmlOutMessage handle(WxMpXmlMessage wxMessage, Map<String, Object> context, WxMpService wxMpService,
                                    WxSessionManager sessionManager) throws WxErrorException {
        String zhengzaiAppId = wechatMpConfigure.getWxMpService(1).getWxMpConfigStorage().getAppId();
        String otherAppId = wxMpService.getWxMpConfigStorage().getAppId();

        log.info("接收到一个订阅事件:[{}]", wxMessage.toString());
        // 1、获取微信用户信息
        WxMpUser wxMpUser = wxMpService.getUserService().userInfo(wxMessage.getFromUser());
        if (null == wxMpUser) {
            log.warn("从微信公众号获取用户(FromUser)信息:[{}]失败.", wxMessage.getFromUser());
            return null;
        }
        log.info("根据 openId:[{}]获取到的微信用户信息:[{}]", wxMessage.getFromUser(), wxMpUser.toString());
        if (zhengzaiAppId.equals(otherAppId)) {
            // 记录用户信息
            SweetWechatUser userInfo = redisDataUtils.getSweetWechatUser(wxMpUser.getUnionId());
            SweetWechatUser sweetWechatUser = SweetWechatUser.getNew();
            sweetWechatUser.setOpenId(wxMpUser.getOpenId());
            sweetWechatUser.setUnionId(wxMpUser.getUnionId());
            sweetWechatUser.setNickname(wxMpUser.getNickname());
            sweetWechatUser.setSexDesc(wxMpUser.getSexDesc());
            sweetWechatUser.setSex(wxMpUser.getSex());
            sweetWechatUser.setHeadImgUrl(wxMpUser.getHeadImgUrl());
            sweetWechatUser.setLanguage(wxMpUser.getLanguage());
            sweetWechatUser.setCountry(wxMpUser.getCountry());
            sweetWechatUser.setProvince(wxMpUser.getProvince());
            sweetWechatUser.setCity(wxMpUser.getCity());
            sweetWechatUser.setSubscribeTime(DateUtil.ofEpochMilli(wxMpUser.getSubscribeTime()));
            sweetWechatUser.setSubscribeScene(wxMpUser.getSubscribeScene());
            if (null == userInfo) {
                sweetWechatUser.setUserId(IDGenerator.nextSnowId());
                LinkedList<String> sqls = CollectionUtil.linkedListString();
                LinkedList<Object[]> sqlsDataA = CollectionUtil.linkedListObjectArr();
                sqls.add(SqlMapping.get("sweet_user.insert"));
                sqlsDataA.add(new Object[]{
                        sweetWechatUser.getUserId(), 1, sweetWechatUser.getOpenId(), sweetWechatUser.getUnionId(), sweetWechatUser.getNickname(),
                        sweetWechatUser.getSexDesc(), sweetWechatUser.getSex(), sweetWechatUser.getHeadImgUrl(), sweetWechatUser.getLanguage(),
                        sweetWechatUser.getCountry(), sweetWechatUser.getProvince(), sweetWechatUser.getCity(),
                        sweetWechatUser.getSubscribeTime(), sweetWechatUser.getSubscribeScene()
                });
                queueUtils.sendMsgByRedis(MQConst.SweetQueue.SWEET_USER_INSERT_DRAW.getKey(),
                        SqlMapping.gets(sqls, sqlsDataA));
                // 入缓存
                redisDataUtils.setSweetWechatUser(sweetWechatUser);
                //发送模版消息
                sweetWechatTemplateService.subscribeSend(wxMpService, sweetWechatUser);
            }
        } else {
            // 记录用户信息
            SweetWechatUser userInfo = redisDataUtils.getSweetWechatUserModernsky(wxMpUser.getUnionId());
            SweetWechatUser sweetWechatUser = SweetWechatUser.getNew();
            sweetWechatUser.setOpenId(wxMpUser.getOpenId());
            sweetWechatUser.setUnionId(wxMpUser.getUnionId());
            sweetWechatUser.setNickname(wxMpUser.getNickname());
            sweetWechatUser.setSexDesc(wxMpUser.getSexDesc());
            sweetWechatUser.setSex(wxMpUser.getSex());
            sweetWechatUser.setHeadImgUrl(wxMpUser.getHeadImgUrl());
            sweetWechatUser.setLanguage(wxMpUser.getLanguage());
            sweetWechatUser.setCountry(wxMpUser.getCountry());
            sweetWechatUser.setProvince(wxMpUser.getProvince());
            sweetWechatUser.setCity(wxMpUser.getCity());
            sweetWechatUser.setSubscribeTime(DateUtil.ofEpochMilli(wxMpUser.getSubscribeTime()));
            sweetWechatUser.setSubscribeScene(wxMpUser.getSubscribeScene());
            if (null == userInfo) {
                sweetWechatUser.setUserId(IDGenerator.nextSnowId());
                LinkedList<String> sqls = CollectionUtil.linkedListString();
                LinkedList<Object[]> sqlsDataA = CollectionUtil.linkedListObjectArr();
                sqls.add(SqlMapping.get("sweet_user.insert"));
                sqlsDataA.add(new Object[]{
                        sweetWechatUser.getUserId(), 2, sweetWechatUser.getOpenId(), sweetWechatUser.getUnionId(), sweetWechatUser.getNickname(),
                        sweetWechatUser.getSexDesc(), sweetWechatUser.getSex(), sweetWechatUser.getHeadImgUrl(), sweetWechatUser.getLanguage(),
                        sweetWechatUser.getCountry(), sweetWechatUser.getProvince(), sweetWechatUser.getCity(),
                        sweetWechatUser.getSubscribeTime(), sweetWechatUser.getSubscribeScene()
                });
                queueUtils.sendMsgByRedis(MQConst.SweetQueue.SWEET_USER_INSERT_DRAW.getKey(),
                        SqlMapping.gets(sqls, sqlsDataA));
                // 入缓存
                redisDataUtils.setSweetWechatUserModernsky(sweetWechatUser);
                //发送模版消息
                sweetWechatTemplateService.subscribeSend(wxMpService, sweetWechatUser);
            }
        }

        return null;
    }
}
