package com.liquidnet.service.controller;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.SmileVProjectListVo;
import com.liquidnet.service.goblin.dto.vo.SmileVProjectVo;
import com.liquidnet.service.goblin.param.SmileVolunteersApplyParam;
import com.liquidnet.service.goblin.service.manage.SmileVolunteersService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author zhangfuxin
 * @Description:用户接口
 * @date 2021/12/27 下午6:25
 */
@Api(tags = "志愿者相关接口")
@RestController
@RequestMapping("/volunteers")
@Slf4j
public class SmileVolunteersController {
    @Autowired
    SmileVolunteersService volunteersService;

    @PostMapping("/project/list")
    @ApiOperation("活动列表")
    public ResponseDto<List<SmileVProjectListVo>> projectList(String uid) {
        return volunteersService.projectList(uid);
    }

    @PostMapping("/project/details")
    @ApiOperation("活动详情")
    public ResponseDto<SmileVProjectVo> projectDetails(String uid, String projectId) {
        return volunteersService.projectDetails(uid, projectId);
    }

    @PostMapping("apply")
    @ApiOperation("活动报名")
    public ResponseDto<Boolean> apply(@RequestBody SmileVolunteersApplyParam param) {
        return volunteersService.apply(param);
    }

}
