package com.liquidnet.client.admin.zhengzai.smile.service;


import com.baomidou.mybatisplus.extension.service.IService;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.zhengzai.smile.dto.SaleDataVo;
import com.liquidnet.client.admin.zhengzai.smile.dto.ShowSort;
import com.liquidnet.client.admin.zhengzai.smile.dto.SmilePriceParam;
import com.liquidnet.client.admin.zhengzai.smile.dto.SmileShowParam;
import com.liquidnet.service.smile.entity.SmileSchool;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author liquidnet
 * @since 2022-03-14
 */
public interface ISmileShowService extends IService<SmileSchool> {

    /**
     * 演出列表
     * @param smileShowParam: 查询条件
     * @return ：TableDataInfo
     */
    TableDataInfo listShow(SmileShowParam smileShowParam);

    /**
     * 演出排序
     * @param showSort ： 演出id和序号
     * @return ：AjaxResult
     */
    AjaxResult sort(ShowSort showSort);

    /**
     * 个人打款打款
     * @param smilePriceParam：参数 演出id，uid，打款标识
     * @return ：
     */
    AjaxResult price(SmilePriceParam smilePriceParam);

    /**
     * 根据演出id查询演出详情
     * @param performancesId ：演出id
     * @return ：AjaxResult
     */
    AjaxResult getShowById(String performancesId);

    /**
     * 销售数据
     * @param performancesId： 演出id
     * @return ：AjaxResult
     */
    SaleDataVo saleData(String performancesId);

    /**
     * 演出标识打款
     * @param smilePriceParam ： SmilePriceParam
     * @return ： AjaxResult
     */
    AjaxResult allPrice(SmilePriceParam smilePriceParam);

    /**
     * 修改原保存演出id的数据类型
     * @return
     */
    AjaxResult updateRedis();

}
