package com.liquidnet.service.kylin.service.impl;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.kylin.dao.KylinTicketActive;
import com.liquidnet.service.kylin.service.IKylinArActiveService;
import com.liquidnet.service.kylin.utils.DataUtils;
import com.liquidnet.service.kylin.utils.QueueUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

/**
 * <p>
 * 人流量检测记录表 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-01-10
 */
@Service
public class KylinArActiveServiceImpl implements IKylinArActiveService {
    @Autowired
    private DataUtils dataUtils;
    @Autowired
    private QueueUtils queueUtils;
    @Override
    public ResponseDto exchange(String code, String uid) {
        //1 查看是否有兑换码
        KylinTicketActive kylinTicketActive=dataUtils.getArTicket(code);
        if(null==kylinTicketActive){
            return ResponseDto.failure("兑换码错误");
        }
        //2、查看该用户是否绑定
        if(null!=dataUtils.getUserStatus(uid)){
            return ResponseDto.failure("该用户已经绑定");
        }
        //判断是否用过卷了
        if(kylinTicketActive.getState()==2){
            return ResponseDto.failure("该券已经兑换");
        }
        //开始绑定
        //修改redis缓存
        dataUtils.setUser(uid,"1");
        kylinTicketActive.setState(2);
        dataUtils.setArTicket(kylinTicketActive);
        //队列 修改券的状态。
        queueUtils.sendMsgByRedis(
                MQConst.KylinQueue.SQL_PERFORMANCE_LACK.getKey(),
                SqlMapping.get(
                        "kylin_ar_ticket.update",
                        new Object[]{
                            2,uid, LocalDateTime.now(),code
                        }
                ));
        return ResponseDto.success();
    }
}
