package com.liquidnet.client.admin.zhengzai.sweet.dto;

import com.liquidnet.client.admin.common.annotation.Excel;
import com.liquidnet.service.kylin.dao.OrderExportDao;
import com.liquidnet.service.sweet.entity.SweetYbActivity;
import com.liquidnet.service.sweet.entity.SweetYbEnroll;
import lombok.Data;

import java.io.Serializable;
import java.time.format.DateTimeFormatter;

@Data
public class SweetYbActivityExportVo implements Serializable, Cloneable {
    @Excel(name = "联系电话", cellType = Excel.ColumnType.STRING)
    private String contactTell;
    @Excel(name = "联系微信", cellType = Excel.ColumnType.STRING)
    private String contactWechat;
    @Excel(name = "乐队名称", cellType = Excel.ColumnType.STRING)
    private String nickname;
    @Excel(name = "风格", cellType = Excel.ColumnType.STRING)
    private String style;
    @Excel(name = "图片地址", cellType = Excel.ColumnType.STRING)
    private String imgUrl;
    @Excel(name = "音频文件地址", cellType = Excel.ColumnType.STRING)
    private String audioUrl;
    @Excel(name = "院校", cellType = Excel.ColumnType.STRING)
    private String universities;
    @Excel(name = "常驻城市名称", cellType = Excel.ColumnType.STRING)
    private String cityName;
    @Excel(name = "创建时间", cellType = Excel.ColumnType.STRING)
    private String createdAt;


    private static final SweetYbActivityExportVo obj = new SweetYbActivityExportVo();

    public static SweetYbActivityExportVo getNew() {
        try {
            return (SweetYbActivityExportVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new SweetYbActivityExportVo();
    }

    public SweetYbActivityExportVo copyOrderExportVo(SweetYbEnroll source) {
        this.setContactTell(source.getContactTell());
        this.setContactWechat(source.getContactWechat());
        this.setNickname(source.getNickname());
        this.setStyle(source.getStyle());
        this.setImgUrl(source.getImgUrl());
        this.setAudioUrl(source.getAudioUrl());
        this.setUniversities(getUniversities());
        this.setCityName(source.getCityName());
        this.setUniversities(source.getUniversities());
        this.setCreatedAt(source.getCreatedAt().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        return this;
    }

}
