package com.liquidnet.client.admin.web.controller.zhengzai.sweet;


import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.utils.poi.ExcelUtil;
import com.liquidnet.client.admin.zhengzai.kylin.dto.OrderMemberExportVo;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileAgentService;
import com.liquidnet.client.admin.zhengzai.sweet.dto.SweetYbActivityExportVo;
import com.liquidnet.client.admin.zhengzai.sweet.service.ISweetYbActivityService;
import com.liquidnet.service.kylin.dao.PerformanceAdminListDao;
import com.liquidnet.service.smile.entity.SmileAgent;
import com.liquidnet.service.sweet.dto.param.admin.SweetYbActivityListParam;
import com.liquidnet.service.sweet.dto.param.admin.SweetYbActivityParam;
import com.liquidnet.service.sweet.dto.vo.SweetYbActivityVo;
import com.liquidnet.service.sweet.entity.SweetYbActivity;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2022-03-16
 */
@Api(tags = "YB活动管理")
@RestController
@RequestMapping("/sweet/activity")
public class SweetYbActivityController {

    @Autowired
    ISweetYbActivityService sweetYbActivityService;

    @PostMapping("/insert")
    @ApiOperation("创建活动")
    @ResponseBody
    public AjaxResult aInsert(@RequestBody SweetYbActivityParam param) {
        return sweetYbActivityService.aInsert(param);
    }

    @GetMapping("/details")
    @ApiOperation("活动详情")
    @ResponseBody
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "activityId", value = "活动id"),
    })
    public SweetYbActivityVo aDetails(String activityId) {
        return sweetYbActivityService.aDetails(activityId);
    }


    @PostMapping("/update")
    @ApiOperation("修改活动")
    @ResponseBody
    public AjaxResult aUpdate(@RequestBody SweetYbActivityParam param) {
        return sweetYbActivityService.aUpdate(param);
    }

    @PostMapping("/status")
    @ApiOperation("修改上线下")
    @ResponseBody
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "activityId", value = "活动id"),
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "status", value = "状态[6-启用|7禁用]"),
    })
    public AjaxResult aStatus(String activityId, Integer status) {
        return sweetYbActivityService.aStatus(activityId, status);
    }

    @PostMapping("/list")
    @ApiOperation("活动列表")
    @ResponseBody
    public TableDataInfo aList(SweetYbActivityListParam param) {
        PageInfo<SweetYbActivityVo> result = sweetYbActivityService.aList(param);
        TableDataInfo rspData = new TableDataInfo();
        rspData.setCode(0);
        rspData.setRows(result.getList());
        rspData.setTotal(result.getTotal());
        return rspData;
    }

    @PostMapping("/export")
    @ApiOperation("活动列表导出")
    @ResponseBody
    public AjaxResult exportMemberOrder(String activityId) {
        List<SweetYbActivityExportVo> list = sweetYbActivityService.aExport(activityId);
        if (list.size() == 0) {
            return AjaxResult.error("查无信息");
        }
        ExcelUtil<SweetYbActivityExportVo> util = new ExcelUtil(SweetYbActivityExportVo.class);
        return util.exportExcel(list, "YB报名数据");
    }

}
