package com.liquidnet.common.third.zxlnft.dto.nft;

import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 52.NFT售价变更
 * @class: NftPriceUpdateReq
 * @Package com.liquidnet.common.third.zxlnft.dto.nft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 16:00
 */
@Data
public class Nft052PriceUpdateReq implements Serializable {
    /**
     * 平台公钥
     */
    private String platformPubKey;
    /**
     * 发起者公钥
     */
    private String operatorPubKey;
    /**
     * 要调价的nftId
     */
    private String nftId;
    /**
     * 销售价格
     */
    private Integer transPrice;
    /**
     * 请求ID，每个请求需要填唯一的ID，重复请求用相同的id
     */
    private String operateId;
    /**
     * 操作者的私钥签名，签名对象是(platformPubKey_operatorPubKey_接口名_nftId_transPrice_operateId)
     * 接口名： nft_update_sell
     */
    private String signature;
    /**
     * 平台方的私钥签名，签名对象和signature对象一致
     */
    private String platformSignature;
    private static final Nft052PriceUpdateReq obj = new Nft052PriceUpdateReq();
    private static final long serialVersionUID = -5202141731791024627L;

    public static Nft052PriceUpdateReq getNew() {
        try {
            return (Nft052PriceUpdateReq) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Nft052PriceUpdateReq();
        }
    }
}
