package com.liquidnet.service.kylin.dto.param;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author zjp
 * @create 2024-03-12 14:36
 */
@ApiModel(value = "KylinPerformanceSubscribeParam", description = "预约入参")
@Data
public class KylinPerformanceSubscribeParam implements Serializable {
    @ApiModelProperty(position = 1, value = "演出id")
    @NotBlank(message = "演出ID不能为空")
    private String performancesId;
    @ApiModelProperty(position = 2,value = "演出名称")
    @NotBlank(message = "演出名称不能为空")
    private String performancesTitle;
    @ApiModelProperty(position = 3,value = "场次id")
    @NotBlank(message = "场次ID不能为空")
    private String ticketTimesId;
    @ApiModelProperty(position = 4,value = "场次名称")
    @NotBlank(message = "场次名称不能为空")
    private String ticketTimesTitle;
    @ApiModelProperty(position = 5,value = "票种id")
    @NotBlank(message = "票种ID不能为空")
    private String timeId;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(position = 7,value = "票种开始时间")
    private LocalDateTime timeStart;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(position = 8,value = "票种结束时间")
    private LocalDateTime  timeEnd;
    @ApiModelProperty(position = 9,value = "设备唯一标识")
    @NotBlank(message = "设备唯一标识不能为空")
    private String deviceTokens;
    @ApiModelProperty(position = 10,value = "演出图片")
    @NotBlank(message = "演出图片不能为空")
    private String imgPoster;
}
