/**
 * $Id: BASE64Util.java 1691 2015-11-25 10:01:57Z yupengfei $
 * Copyright(C) 2014-2020 netease - easegame, All Rights Reserved.
 */
package com.liquidnet.commons.lang.util;

import org.apache.commons.codec.binary.Base64;

import java.io.UnsupportedEncodingException;

/**
 *
 * @author <a href="mailto:yupengfei@kowlone.com">kowlone</a>
 * @version 1.0 2015年10月27日 下午2:24:04
 */
public class BASE64Util {

	public final static String ENCODING = "UTF-8";

    // 加密
    public static String encoded(String data) throws UnsupportedEncodingException {
        byte[] b = Base64.encodeBase64(data.getBytes(ENCODING));
        return new String(b, ENCODING);
    }

    // 加密,遵循RFC标准
    public static String encodedSafe(String data) throws UnsupportedEncodingException {
        byte[] b = Base64.encodeBase64(data.getBytes(ENCODING),true);
        return new String(b, ENCODING);
    }

    // 解密
    public static String decode(String data) throws UnsupportedEncodingException {
        byte[] b = Base64.decodeBase64(data.getBytes(ENCODING));
        return new String(b, ENCODING);
    }
    public static void main(String[] args) throws UnsupportedEncodingException {

    	 String str = "yupengfei@kowlone.com";
         // 加密该字符串
         String encodedString = BASE64Util.encodedSafe(str);
         System.out.println(encodedString);
         // 解密该字符串
         String decodedString = BASE64Util.decode(encodedString);
         System.out.println(decodedString);
    }


}
