/**
 * $Id: CollectionUtil.java 3776 2016-03-10 06:43:12Z lizhongmin $
 * Copyright(C) 2014-2020 easegame, All Rights Reserved.
 */
package com.liquidnet.commons.lang.util;

import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;

/**
 * @author <a href="mailto:wangwei@kowlone.com">kowlone</a>
 * @version 1.0 2015年12月01日 11:42:00
 */
public class CollectionUtil {

	/**
	 * 构建泛型类型的HashMap,该Map的初始容量是0
	 *
	 * @param <K>
	 * @param <V>
	 * @return
	 */
	public static <K, V> Map<K, V> hashMap() {
		return new HashMap<K, V>(0);
	}

	public static <K, V> Map<K, V> concurrentMap() {
		return new ConcurrentHashMap<K, V>();
	}


	public static <E> List<E> arrayList () {
		return new ArrayList<E>();
	}

	public static <E> List<E> arrayList (E obj) {
		List<E> _list = arrayList();
		_list.add(obj);
		return _list;
	}

	public static <E> LinkedList<E> linkedList () {
		return new LinkedList<E>();
	}

	public static <E> Set<E> hashSet () {
		return new HashSet<E>();
	}

	public static <E> List<E> arrayList (Collection<E> c) {
		return new ArrayList<E>(c);
	}

	public static <E> Set<E> hashSet (Collection<E> c) {
		return new HashSet<E>(c);
	}


	@SuppressWarnings("unchecked")
	public static <T> T get (Map<?, ?> map, Object obj, Class<T> clazz) {
		return (T)map.get(obj);
	}

	public static <E> boolean isEmpty (Collection<E> c) {
		return c == null || c.isEmpty();
	}

	/**
	 * 移除集合中符合条件的元素
	 * @param list List集合
	 * @param test 移除条件
	 * @param breakIfFind 是否在第一次移除后就停止查找
	 * @param <T>
	 */
	public static <T> void remove(List<T> list,Predicate<T> test,boolean breakIfFind){
		if(list == null) {
            return;
        }
		Iterator<T> it = list.iterator();
		while (it.hasNext()){
			if(test.test(it.next())){
				it.remove();
				if (breakIfFind) {
					break;
				}
			}
		}
	}

	/**
	 * 遍历全部元素,并移除其中符合条件的元素
	 * @param list List集合
	 * @param test 移除条件
	 * @param <T>
	 */
	public static <T> void remove(List<T> list,Predicate<T> test){
		remove(list,test,false);
	}

	/**
	 * 遍历全部元素,并移除其中与目标对象相同的元素
	 * @param list List集合
	 * @param targetElement 目标对象
	 * @param <T>
	 */
	public static <T> void remove(List<T> list, T targetElement) {
		remove(list, (Predicate<T>) t -> t.equals(targetElement));
	}

	/**
	 * 遍历全部元素,并移除其中的null元素
	 * @param list List集合
	 * @param <T>
	 */
	public static <T> void removeNull(List<T> list) {
		remove(list, (Predicate<T>) t -> t == null);
	}


	/**
	 * 遍历map中的全部value,并且移除符合条件的元素
	 * @param map Map集合
	 * @param test 移除条件
	 * @param <V>
	 */
	public static <V> void remove(Map<?, V> map, Predicate<V> test) {
		if(map == null) {
            return;
        }
		Iterator<V> it = map.values().iterator();
		while (it.hasNext()) {
			if (test.test(it.next())) {
				it.remove();
			}
		}
	}

	/**
	 * 遍历map中的全部value,并且移除与目标对象相同的元素
	 * @param map Map集合
	 * @param targetElement 目标对象
	 * @param <V>
	 */
	public static <V> void remove(Map<?, V> map, V targetElement) {
		remove(map, (Predicate<V>) v -> v.equals(targetElement));
	}

	/**
	 * 遍历map中的全部value,并且移除其中的null值元素
	 * @param map Map集合
	 * @param <V>
	 */
	public static <V> void removeNull(Map<?, V> map) {
		remove(map, (Predicate<V>) v -> v == null);
	}

}
