package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinGoodsAnticipateValueVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author TT
 */

@ApiModel(value = "NoticeGoblinGoodsSkuInfoVo", description = "票务")
@Data
public class NoticeGoblinGoodsSkuInfoVo implements Serializable, Cloneable {

    @ApiModelProperty(value = "商品单品ID")
    private String skuId;
    @ApiModelProperty(value = "商品ID[64]")
    private String spuId;
    @ApiModelProperty(value = "单品的编号[45]")
    private String skuNo;
    @ApiModelProperty(value = "商品类型[0-常规|1-数字藏品]")
    private int skuType;
    @ApiModelProperty(value = "单品的名称[100]")
    private String name;
    @ApiModelProperty(value = "单品的副标题[128]")
    private String subtitle;
    @ApiModelProperty(value = "单品默认图片的URL[256]")
    private String skuPic;
    @ApiModelProperty(value = "单品详情展示文件URL[256]")
    private String skuWatch;
    @ApiModelProperty(value = "展示文件类型[1-图片|2-视频|3-模型]")
    private String watchType;
    @ApiModelProperty(value = "展示预览图片URL[256]")
    private String skuWatchPic;
    @ApiModelProperty(value = "素材原始文件类型[1-图片|2-视频|3-模型]")
    private String materialType;
    @ApiModelProperty(value = "素材原始文件URL")
    private String materialUrl;
    @ApiModelProperty(value = "单品销售价-原价[20,2]")
    private BigDecimal sellPrice;
    @ApiModelProperty(value = "单品现价[20,2]")
    private BigDecimal price;
    @ApiModelProperty(value = "IOS商品价格[20,2]")
    private BigDecimal priceV;
    @ApiModelProperty(value = "IOS商品价格ID")
    private String productId;
    @ApiModelProperty(value = "单品会员价格[20,2]")
    private BigDecimal priceMember;
    @ApiModelProperty(value = "NFT路由")
    private String routeType;
    @ApiModelProperty(value = "NFT上传声明状态[0-待上传|1-已声明|2-声明失败|9-声明中]")
    private Integer upchain;
    @ApiModelProperty(value = "NFT预览图访问URL")
    private String displayUrl;
    @ApiModelProperty(value = "NFT素材访问URL")
    private String nftUrl;
    @ApiModelProperty(value = "NFT系列ID")
    private String seriesId;
    @ApiModelProperty(value = "NFT系列HASH")
    private String seriesHash;
    @ApiModelProperty(value = "NFT藏品HASH")
    private String nftHash;
    @ApiModelProperty(value = "NFT系列声明时间")
    private String declareAt;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    @ApiModelProperty(value = "开售时间")
    private LocalDateTime saleStartTime;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    @ApiModelProperty(value = "停售时间")
    private LocalDateTime saleStopTime;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    @ApiModelProperty(value = "预约开始时间")
    private LocalDateTime aboutStartTime;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    @ApiModelProperty(value = "预约停止时间")
    private LocalDateTime aboutStopTime;

    private static final NoticeGoblinGoodsSkuInfoVo obj = new NoticeGoblinGoodsSkuInfoVo();

    public static NoticeGoblinGoodsSkuInfoVo getNew() {
        try {
            return (NoticeGoblinGoodsSkuInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new NoticeGoblinGoodsSkuInfoVo();
        }
    }

    public NoticeGoblinGoodsSkuInfoVo copy(GoblinGoodsSkuInfoVo goblinGoodsSkuInfoVo) {
        if (null == goblinGoodsSkuInfoVo) return getNew();
        this.declareAt = goblinGoodsSkuInfoVo.getDeclareAt();
        this.displayUrl = goblinGoodsSkuInfoVo.getDisplayUrl();
        this.price = goblinGoodsSkuInfoVo.getPrice();
        this.materialType = goblinGoodsSkuInfoVo.getMaterialType();
        this.materialUrl = goblinGoodsSkuInfoVo.getMaterialUrl();
        this.name = goblinGoodsSkuInfoVo.getName();
        this.nftHash = goblinGoodsSkuInfoVo.getNftHash();
        this.nftUrl = goblinGoodsSkuInfoVo.getNftUrl();
        this.priceV = goblinGoodsSkuInfoVo.getPriceV();
        this.priceMember = goblinGoodsSkuInfoVo.getPriceMember();
        this.productId = goblinGoodsSkuInfoVo.getProductId();
        this.routeType = goblinGoodsSkuInfoVo.getRouteType();
        this.saleStartTime = goblinGoodsSkuInfoVo.getSaleStartTime();
        this.saleStopTime = goblinGoodsSkuInfoVo.getSaleStopTime();
        this.sellPrice = goblinGoodsSkuInfoVo.getSellPrice();
        this.seriesHash = goblinGoodsSkuInfoVo.getSeriesHash();
        this.seriesId = goblinGoodsSkuInfoVo.getSeriesId();
        this.skuId = goblinGoodsSkuInfoVo.getSkuId();
        this.skuNo = goblinGoodsSkuInfoVo.getSkuNo();
        this.skuPic = goblinGoodsSkuInfoVo.getSkuPic();
        this.skuType = goblinGoodsSkuInfoVo.getSkuType();
        this.spuId = goblinGoodsSkuInfoVo.getSpuId();
        this.skuWatch = goblinGoodsSkuInfoVo.getSkuWatch();
        this.skuWatchPic = goblinGoodsSkuInfoVo.getSkuWatchPic();
        this.subtitle = goblinGoodsSkuInfoVo.getSubtitle();
        this.upchain = goblinGoodsSkuInfoVo.getUpchain();
        this.watchType = goblinGoodsSkuInfoVo.getWatchType();
        return this;
    }


    public NoticeGoblinGoodsSkuInfoVo valueCopy(GoblinGoodsAnticipateValueVo valueVo) {
        if (null == valueVo) return getNew();
        this.aboutStartTime = valueVo.getAboutStartDate();
        this.aboutStopTime = valueVo.getAboutEndDate();
        return this;
    }
}
