package com.liquidnet.service.goblin.param;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @Author: wll
 * @Date:Create：in 2022/4/19 5:06 下午
 */

@ApiModel(value = "GoblinNftExActivityParam", description = "添加方法入参")
@Data
public class GoblinNftExSkuParam implements Serializable {


    @ApiModelProperty(position = 10, required = true, value = "nft兑换活动id")
    // @NotBlank(message = "nft兑换活动id不可为空")
    private String activityId;

    @ApiModelProperty(position = 11,required = true,value = "店铺id")
    private String storeId;


    @ApiModelProperty(position = 12,required = true,value = "商品id")
    // @NotBlank(message = "商品id不可为空")
    private String spuId;

    @ApiModelProperty(position = 13,required = true,value = "款式id")
    // @NotBlank(message = "款式id不可为空")
    private String skuId;

    @ApiModelProperty(position = 14,required = true,value = "是否盲盒 0：否 1：是")
    // @NotBlank(message = "是否盲盒 0：否 1：是")
    private String unbox;

    @ApiModelProperty(position = 15,required = true,value = "兑换库存数量")
    // @NotBlank(message = "兑换库存数量不可为空")
    private Integer exStock;

    @ApiModelProperty(position = 16,required = true,value = "兑换限购数量")
    // @NotBlank(message = "兑换限购数量不可为空")
    private Integer exLimit;

    @ApiModelProperty(position = 17,required = true,value = "兑换生效开始时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    // @NotBlank(message = "兑换生效开始时间不可为空")
    private LocalDateTime exStartTime;

    @ApiModelProperty(position = 18,required = true,value = "兑换生效结束时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
   //  @NotBlank(message = "兑换生效结束时间不可为空")
    private LocalDateTime exStopTime;


}
