package com.liquidnet.client.admin.zhengzai.kylin.dto;

import lombok.Data;

import java.util.List;

@Data
public class PerformanceTicketSalesDto {

    /**
     * 总销售票款(元)
     */

    private String fullSalesAmountTotal;

    /**
     * 观众购票数
     */
    private Integer fullAudienceTicketTotal;

    /**
     * 总库存
     */
    private Integer fullTotalGeneral;

    /**
     * 退票数量(张)
     */
    private Integer fullRefundTicketTotal;

    /**
     * 票种销售数据
     */
    private List<TicketSales> fullTicketDataList;


    @Data
    public static class TicketSales {
        // 票ID
        private String ticketId;

        // 场次ID
        private String timeId;

        // 场次名称
        private String timeTitle;

        // 票种名称
        private String ticketTitle;

        // 票种金额
        private String ticketPrice;

        // 销售总金额
        private String salesAmountTotal;

        // 退票手续费总收益
        private String refundFeeRevenueTotal;

        // 观众购票总数[销售总票量-兑换码票总数]
        private String audienceTicketTotal;

        // 观众购票销售总金额[票种金额* 观众购票总数]
        private String audienceSalesAmountTotal;

        // 全额退票总数
        private String fullRefundTicketTotal;

        // 手续费退票总数
        private String handlingFeeRefundTicketTotal;

        // 退票总数量
        private String refundTicketTotal;

        // 票种类型 1：单日票 2：通票
        private String ticketType;

        // 库存数量
        private String totalGeneral;

        // 登登登VIP购买数量
        private String vipBuyTotal;

        // 正在支付数量
        private String payingTotal;
    }
}
