package com.liquidnet.service.sweet.service.impl;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.sweet.dto.param.poster.SweetStrawListParam;
import com.liquidnet.service.sweet.dto.param.poster.SweetStrawMusicianParam;
import com.liquidnet.service.sweet.dto.param.poster.SweetStrawberryParam;
import com.liquidnet.service.sweet.entity.SweetStrawberryPoster;
import com.liquidnet.service.sweet.mapper.SweetStrawberryPosterMapper;
import com.liquidnet.service.sweet.service.ISweetStrawberryPosterService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.service.sweet.utils.QueueUtils;
import com.liquidnet.service.sweet.utils.RedisDataUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.List;

/**
 * <p>
 * 2021草莓音乐节海报活动表 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-11-25
 */
@Service
public class SweetStrawberryPosterServiceImpl extends ServiceImpl<SweetStrawberryPosterMapper, SweetStrawberryPoster> implements ISweetStrawberryPosterService {

    @Autowired
    QueueUtils queueUtils;
    @Autowired
    private RedisDataUtils redisDataUtils;
    @Autowired
    StringRedisTemplate stringRedisTemplate;

    @Override
    public ResponseDto<Boolean> addUserLikeMusician(SweetStrawberryParam sweetStrawberry) {

        String posterId = IDGenerator.nextSnowId(); //生成海报id

        LocalDateTime localDateTime = DateUtil.asLocalDateTime(DateUtil.now()); //生成创建时间

        String openId=sweetStrawberry.getOpenId();
        String unionId = sweetStrawberry.getUnionId();
        String nickname=sweetStrawberry.getNickname();
        String cityCode=sweetStrawberry.getCityCode();
        String cityName=sweetStrawberry.getCityName();
       List<SweetStrawListParam> musicianList = sweetStrawberry.getMusicianList();
        for (SweetStrawListParam sweetStrawListParam : musicianList) {
            List<SweetStrawMusicianParam> lineup = sweetStrawListParam.getLineup();
            for (SweetStrawMusicianParam param : lineup) {
                String lineupNum = param.getLineupNum();
                Integer musicianId = param.getMusicianId();
                String musicianName = param.getMusicianName();
                String lineupId=IDGenerator.nextSnowId();
                //存sql
                LinkedList<String> sqls = CollectionUtil.linkedListString();
                LinkedList<Object[]> sqlsDataA = CollectionUtil.linkedListObjectArr();
                sqls.add(SqlMapping.get("sweet_strawberry_poster_Musician"));
                sqlsDataA.add(new Object[]{lineupId, posterId,lineupNum, musicianId, musicianName,localDateTime,null});
                queueUtils.sendMsgByRedis(MQConst.SweetQueue.SWEET_POSTER.getKey(), SqlMapping.gets(sqls, sqlsDataA));
            }
        }

        LinkedList<String> sqls = CollectionUtil.linkedListString();
        LinkedList<Object[]> sqlsDataA = CollectionUtil.linkedListObjectArr();
        sqls.add(SqlMapping.get("sweet_strawberry_poster_user"));
        sqlsDataA.add(new Object[]{openId,posterId,unionId,nickname,cityName,cityCode,localDateTime,null});
        queueUtils.sendMsgByRedis(MQConst.SweetQueue.SWEET_POSTER.getKey(),
                SqlMapping.gets(sqls, sqlsDataA));


        //存reids
        redisDataUtils.setSweetMusician(sweetStrawberry);
        return ResponseDto.success();
    }

}
