package com.liquidnet.service.adam.service.processor;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.adam.dto.vo.AdamAddressesVo;
import com.liquidnet.service.adam.entity.AdamAddresses;
import com.liquidnet.service.adam.mapper.AdamAddressesMapper;
import com.liquidnet.service.adam.service.DataMigrationProcessorService;
import com.mysql.cj.jdbc.result.ResultSetImpl;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class DMAddressesProcessor extends DataMigrationProcessorService {
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    RedisUtil redisUtil;
    @Autowired
    AdamAddressesMapper addressesMapper;

    @SneakyThrows
    @Override
    protected void dataProcessing(boolean flg) {
        String sqlCount = "select count(1) from addresses where 1=1";
        String field = "id,user_id,user_name,user_phone,province,city,county,user_address,defaultDelivery,created_at";
//                     1-id,2-user_id,3-user_name,4-user_phone,5-province,6-city,7-county,8-user_address,9-defaultDelivery,10-created_at
        String sql = sqlCount.replace("count(1)", field);

        if (flg) {
            sqlCount += " and user_id in ('2026628','544327','1997335','773650','809406')";
            sql += " and user_id in ('2026628','544327','1997335','773650','809406')";
        }

        sql += " limit ?,?";

        statement = connection.prepareStatement(sqlCount);
        row = (ResultSetImpl) statement.executeQuery();
        row.first();
        int ct = row.getInt(1), pSize = 2, num = 0;
        log.info("DM数据迁移总数:{}", ct);


        while (ct > 0) {
            statement = connection.prepareStatement(sql);
            statement.setInt(1, pSize * num);
            statement.setInt(2, pSize);
            row = (ResultSetImpl) statement.executeQuery();
            log.info("DM.execute.limit:[pNo:{},pSize:{}]", pSize * num, pSize);
            while (row.next()) {
                String uid = row.getString(2);

                if (!reUidList.contains(uid)) {
                    AdamAddresses addresses = new AdamAddresses();
                    addresses.setAddressesId(row.getString(1));
                    addresses.setUid(uid);
                    addresses.setName(row.getString(3));
                    addresses.setPhone(row.getString(4));
                    addresses.setProvince(row.getString(5));
                    addresses.setCity(row.getString(6));
                    addresses.setCounty(row.getString(7));
                    addresses.setAddress(row.getString(8));
                    addresses.setIsDefault(row.getBoolean(9));
                    addresses.setState(1);
                    addresses.setCreatedAt(row.getLocalDateTime(10));

                    AdamAddressesVo vo = AdamAddressesVo.getNew().copy(addresses);

                    addressesMapper.insert(addresses);
                    mongoTemplate.insert(vo, AdamAddressesVo.class.getSimpleName());
                }
            }
            

            num++;
            ct -= pSize;
        }
    }
}
