package com.liquidnet.service.bank.currencycloud.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.annotation.Nullable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * currency cloud conversion param
 */
@Data
@ApiModel(description = "currency cloud rate param")
public class BankCcRateParam {

    @ApiModelProperty(value = "contactId")
    private String contactId;

    @ApiModelProperty(value = "Currency purchased. Three-digit code.",required = true)
    private String buyCurrency;

    @ApiModelProperty(value = "Currency sold. Three-digit code.",required = true)
    private String sellCurrency;

    @ApiModelProperty(allowableValues = "buy,sell", value = "Fix the buy or sell currency.",required = true)
    private String fixedSide;

    @ApiModelProperty(value = "Amount of the fixed buy or sell currency.",required = true)
    private BigDecimal amount;

    @ApiModelProperty(value = "Date of delivery of purchase currency. ISO 8601 format YYYY-MM-DD. If not specified, deals settle in two working days.",required = true)
    private String conversionDate;

    @ApiModelProperty(hidden = true, allowableValues = "earliest,default,optimize_liquidity", value = "Available only if conversion_date is not provided. Must be one of the following:\n" +
            "'earliest' for earliest available conversion date. Make sure there is sufficient time to send funds to Currencycloud.\n" +
            "'default' for conversion - T+1 for APAC, T+2 for everywhere else.\n" +
            "'optimize_liquidity' for maximizing chances of getting a successful rate. Most relevant for exotic pairs. Conversion is within 1 or 2 working days depending on currencies.")
    private String conversionDatePreference;

}
