package com.liquidnet.client.admin.web.controller.adam.transaction;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.PageDomain;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.core.page.TableSupport;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.client.admin.common.utils.poi.ExcelUtil;
import com.liquidnet.client.admin.web.service.adam.transaction.IAdamTransactionService;
import com.liquidnet.client.admin.web.vo.adam.transaction.AdamConversionRecordVo;
import com.liquidnet.client.admin.web.vo.adam.transaction.AdamPayoutRecordVo;
import com.liquidnet.client.admin.web.vo.adam.transaction.AdamRechargeRecordVo;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.adam.dto.admin.transaction.AdamConversionRecordReq;
import com.liquidnet.service.adam.dto.admin.transaction.AdamPayoutRecordReq;
import com.liquidnet.service.adam.dto.admin.transaction.AdamRechargeRecordReq;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api(tags = "Adam trans query")
@Controller
@RequestMapping("/adam/trans-query")
public class TransactionQueryController extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(TransactionQueryController.class);
    private String prefix = "adam/transquery";

    @Autowired
    private IAdamTransactionService adamTransactionService;

    @GetMapping("/rechargeListPage")
    public String rechargeListPage()
    {
        return prefix + "/rechargeList";
    }

    @ApiOperation(value = "充值订单查询分页列表")
    @PostMapping("/rechargeList")
    @RequiresPermissions("adam:trans-query:rechargeList")
    @ResponseBody
    public TableDataInfo rechargeList(AdamRechargeRecordReq adamRechargeRecordReq)
    {
        log.info(JsonUtils.toJson(adamRechargeRecordReq));
        PageDomain pageDomain = TableSupport.buildPageRequest();
        Integer pageNum = pageDomain.getPageNum();
        Integer pageSize = pageDomain.getPageSize();
        Page<AdamRechargeRecordVo> page = adamTransactionService.rechargeList(adamRechargeRecordReq,
                pageNum, pageSize);
        return buildTableDataInfo(page);
    }

    @Log(title = "充值订单导出", businessType = BusinessType.EXPORT)
    @RequiresPermissions("adam:trans-query:rechargeListExport")
    @PostMapping("/rechargeListExport")
    @ResponseBody
    public AjaxResult rechargeListExport(AdamRechargeRecordReq adamRechargeRecordReq)
    {
        log.info(JsonUtils.toJson(adamRechargeRecordReq));
        PageDomain pageDomain = TableSupport.buildPageRequest();
        Integer pageNum = 1;
        Integer pageSize = 100000;
        Page<AdamRechargeRecordVo> page = adamTransactionService.rechargeList(adamRechargeRecordReq,
                pageNum, pageSize);
        List<AdamRechargeRecordVo> list = page.getRecords();
        ExcelUtil<AdamRechargeRecordVo> util = new ExcelUtil<AdamRechargeRecordVo>(AdamRechargeRecordVo.class);
        return util.exportExcel(list, "rechargeList");
    }

    @GetMapping("/payoutListPage")
    public String payoutListPage()
    {
        return prefix + "/payoutList";
    }

    @ApiOperation(value = "下发订单查询分页列表")
    @PostMapping("/payoutList")
    @RequiresPermissions("adam:trans-query:payoutList")
    @ResponseBody
    public TableDataInfo payoutList(AdamPayoutRecordReq adamPayoutRecordReq)
    {
        System.out.println(JsonUtils.toJson(adamPayoutRecordReq));
        PageDomain pageDomain = TableSupport.buildPageRequest();
        Integer pageNum = pageDomain.getPageNum();
        Integer pageSize = pageDomain.getPageSize();
        Page<AdamPayoutRecordVo> page = adamTransactionService.payoutList(adamPayoutRecordReq,
                pageNum, pageSize);
        return buildTableDataInfo(page);
    }

    @Log(title = "下发订单导出", businessType = BusinessType.EXPORT)
    @RequiresPermissions("adam:trans-query:rechargeListExport")
    @PostMapping("/payoutListExport")
    @ResponseBody
    public AjaxResult payoutListExport(AdamPayoutRecordReq adamPayoutRecordReq)
    {
        log.info(JsonUtils.toJson(adamPayoutRecordReq));
        PageDomain pageDomain = TableSupport.buildPageRequest();
        Integer pageNum = 1;
        Integer pageSize = 100000;
        Page<AdamPayoutRecordVo> page = adamTransactionService.payoutList(adamPayoutRecordReq,
                pageNum, pageSize);
        List<AdamPayoutRecordVo> list = page.getRecords();
        ExcelUtil<AdamPayoutRecordVo> util = new ExcelUtil<AdamPayoutRecordVo>(AdamPayoutRecordVo.class);
        return util.exportExcel(list, "payoutList");
    }

    @RequiresPermissions("monitor:operlog:detail")
    @GetMapping("/payoutDetail/{orderId}")
    public String payoutDetail(@PathVariable("orderId") String orderId, ModelMap mmap)
    {
        mmap.put("payoutDetail", adamTransactionService.getPayoutDetailByOrderId(orderId));
        return prefix + "/payoutDetail";
    }

    @GetMapping("/conversionListPage")
    public String conversionListPage()
    {
        return prefix + "/conversionList";
    }

    @ApiOperation(value = "换汇订单查询分页列表")
    @PostMapping("/conversionList")
    @RequiresPermissions("adam:trans-query:conversionList")
    @ResponseBody
    public TableDataInfo conversionList(AdamConversionRecordReq adamConversionRecordReq)
    {
        System.out.println(JsonUtils.toJson(adamConversionRecordReq));
        PageDomain pageDomain = TableSupport.buildPageRequest();
        Integer pageNum = pageDomain.getPageNum();
        Integer pageSize = pageDomain.getPageSize();
        Page<AdamConversionRecordVo> page = adamTransactionService.conversionList(adamConversionRecordReq,
                pageNum, pageSize);
        return buildTableDataInfo(page);
    }

    @Log(title = "下发订单导出", businessType = BusinessType.EXPORT)
    @RequiresPermissions("adam:trans-query:rechargeListExport")
    @PostMapping("/conversionListExport")
    @ResponseBody
    public AjaxResult conversionListExport(AdamConversionRecordReq adamConversionRecordReq)
    {
        log.info(JsonUtils.toJson(adamConversionRecordReq));
        PageDomain pageDomain = TableSupport.buildPageRequest();
        Integer pageNum = 1;
        Integer pageSize = 100000;
        Page<AdamConversionRecordVo> page = adamTransactionService.conversionList(adamConversionRecordReq,
                pageNum, pageSize);
        List<AdamConversionRecordVo> list = page.getRecords();
        ExcelUtil<AdamConversionRecordVo> util = new ExcelUtil<>(AdamConversionRecordVo.class);
        return util.exportExcel(list, "conversionList");
    }

    private TableDataInfo buildTableDataInfo(Page page) {
        TableDataInfo rspData = new TableDataInfo();
        rspData.setCode(0);
        rspData.setRows(page.getRecords());
        rspData.setTotal(page.getTotal());
        return rspData;
    }

    //    public AjaxResult rechargeListExport(AdamRechargeRecordReq adamRechargeRecordReq)
//    {
//        log.info(JsonUtils.toJson(adamRechargeRecordReq));
//        PageDomain pageDomain = TableSupport.buildPageRequest();
//        Integer pageNum = 1;
//        Integer pageSize = 100000;
//        ResponseDto<Page<AdamRechargeRecordResp>> pageResponseDto = feignTransactionQueryClient.rechargeList(adamRechargeRecordReq,
//                pageNum, pageSize);
//
//        List<AdamRechargeRecordResp> list = pageResponseDto.getData().getRecords();
//        List<AdamRechargeRecordVo> voList = new ArrayList<>();
//        list.forEach(record -> {
//            AdamRechargeRecordVo vo = new AdamRechargeRecordVo();
//            BeanUtils.copyProperties(record, vo);
//            voList.add(vo);
//        });
//        ExcelUtil<AdamRechargeRecordVo> util = new ExcelUtil<AdamRechargeRecordVo>(AdamRechargeRecordVo.class);
//        return util.exportExcel(voList, "rechargeList");
//    }
}
