package com.liquidnet.service.goblin.dto.manage.vo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsInfoVo;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsSkuInfoVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@ApiModel(value = "GoblinStoreMgtGoodsInfoVo", description = "商品管理:商品详情信息")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinStoreMgtGoodsInfoVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 4864134079879227233L;
    @ApiModelProperty(position = 11, value = "商品SPU详情")
    private GoblinGoodsInfoVo goodsInfoVo;
    @ApiModelProperty(position = 12, value = "商品SKU信息列表")
    private List<GoblinGoodsSkuInfoVo> goodsSkuInfoVoList;

    private static final GoblinStoreMgtGoodsInfoVo obj = new GoblinStoreMgtGoodsInfoVo();
    public static GoblinStoreMgtGoodsInfoVo getNew() {
        try {
            return (GoblinStoreMgtGoodsInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinStoreMgtGoodsInfoVo();
        }
    }
}
